C
C------------------------------------------------------
C
C     Problem:    CAT_SD
C
C     Date:       10.9.2004
C
C------------------------------------------------------
C           
*     REAL CONSTANT
      S  = 20
      KM = 13.7
      ET = 0.0001
      IT = 3
C
C------------------------------------------------------
C           
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      kEi, kIon, kIoff, kcIs, kcSs, KI
      Ez, EI, Iz, P, ES, E, EsI, I, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Ez_t 
      kcI = kcIs*10000
      kcS = kcSs*10000
      Ez_t = E*kEi
C
*     FUNCTION EI_t
      EI_t = E*I*kIon - EI*kIoff
C
*     FUNCTION Iz_t
      Iz_t = EsI*kcI
C
*     FUNCTION P_t
      P_t = ES*kcS
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION Equ1
      Equ1 = ES - E*S/KM
C
*     FUNCTION Equ2
      Equ2 = EsI - E*I/KI
C
*     FUNCTION Equ3
      Equ3 = ET - E - Ez - ES - EI - EsI
C
*     FUNCTION Equ4
      Equ4 = IT - EI - EsI - Iz - I
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Ez_0
      Ez_0 = 0
C
*     FUNCTION EI_0
      EI_0 = 0
C
*     FUNCTION Iz_0
      Iz_0 = 0
C
*     FUNCTION P0_0
      P0_0 = 0
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION I_0
      alpha=KI*(1 + S/KM) + Iz + ET - Ez - IT
      beta=KI*(1 + S/KM)*(Iz + EI - IT)
      I_0 = -alpha/2 + SQRT(alpha**2/4 - beta)
C
*     FUNCTION E_0
      E_0 = (ET - Ez - EI)/(1 + S/KM + I/KI)
C
*     FUNCTION ES_0
      ES_0 = E*S/KM
C
*     FUNCTION EsI_0
      EsI_0 = E*I/KI
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Ez_fit
      Ez_fit = Ez
C
*     FUNCTION EI_fit
      EI_fit = EI
C
*     FUNCTION Iz_fit
      Iz_fit = Iz
C
*     FUNCTION P_fit
      P_fit = P
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
