C
C------------------------------------------------------
C
C     Problem:    CAT_HYD
C
C     Date:       9.11.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      n = 1
      R = 8.314
      DH = -5.86E4
      rho_cv = 2.55E6
      Sv = 1.57E2
      Ta = 319.3
      C0 = 5.3E3
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      U, C, T, time
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION C_t
      if (C.gt.0) then
        Cn = C**n
      else
        Cn = 0
      endif
      k = 1.45E6*exp(-9.35E4/(R*T))*C
      C_t = -k*Cn
C
*     FUNCTION T_t
      T_t = (-DH*k*Cn - Sv*U*(T - Ta))/rho_cv
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION C_0
      C_0 = C0
C
*     FUNCTION T_0
      T_0 = Ta
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION C_fit
      C_fit = C
C
*     FUNCTION T_fit
      T_fit = T
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

