C
C------------------------------------------------------
C
C     Problem:    CATALYST
C
C     Date:       30.05.2002
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind1 = 1..10
      ind2 = 1,2,3
C
C------------------------------------------------------
C
*     TABLE c(i,j), i in ind1, j in ind2
      1  1  -0.008
      1  2   0.675
      1  3  -0.0014
      2  1  -35.0
      2  2   42.8
      2  3  -17.3
      3  1  -95.6
      3  2   113.0
      3  3  -44.3 
      4  1  -719.8 
      4  2   827.7
      4  3  -316.6
      5  1   -0.658
      5  2   12.17
      5  3  -6.667
      6  1  -0.0795
      6  2   0.1106
      6  3  -0.05033
      7  1  -0.4697
      7  2   0.5539
      7  3  -0.2166
      8  1  -25.27
      8  2   29.93
      8  3  -12.0
      9  1   1.679
      9  2  -1.7778
      9  3   0.4975
      10 1   0.01005
      10 2  -0.01987
      10 3   0.009833
C
C------------------------------------------------------
C
*     CONINT u
         0.0   0.6651
       100.0   0.6651
       200.0   0.6721
       300.0   0.9
      2000.0   0.9
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      c0(i), i in ind1
      x1, x2, x3, x4, x5, x6, x7, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      k1 = c0(1) + c(1,1)*u(t) + c(1,2)*u(t)**2 + c(1,3)*u(t)**3
      k2 = c0(2) + c(2,1)*u(t) + c(2,2)*u(t)**2 + c(2,3)*u(t)**3
      k3 = c0(3) + c(3,1)*u(t) + c(3,2)*u(t)**2 + c(3,3)*u(t)**3
      k4 = c0(4) + c(4,1)*u(t) + c(4,2)*u(t)**2 + c(4,3)*u(t)**3
      k5 = c0(5) + c(5,1)*u(t) + c(5,2)*u(t)**2 + c(5,3)*u(t)**3
      k6 = c0(6) + c(6,1)*u(t) + c(6,2)*u(t)**2 + c(6,3)*u(t)**3
      k7 = c0(7) + c(7,1)*u(t) + c(7,2)*u(t)**2 + c(7,3)*u(t)**3
      k8 = c0(8) + c(8,1)*u(t) + c(8,2)*u(t)**2 + c(8,3)*u(t)**3
      k9 = c0(9) + c(9,1)*u(t) + c(9,2)*u(t)**2 + c(9,3)*u(t)**3
      k10 = c0(10) + c(10,1)*u(t) + c(10,2)*u(t)**2 + c(10,3)*u(t)**3
C
      x1_t = -k1*x1
C
*     FUNCTION x2_t
      x2_t = k1*x1 - (k2 + k3)*x2 + k4*x5
C
*     FUNCTION x3_t
      x3_t = k2*x2
C
*     FUNCTION x4_t
      x4_t = -k6*x4 + k5*x5
C
*     FUNCTION x5_t
      x5_t = k3*x2 + k6*x4 - (k4 + k5 + k8 + k9)*x5 + k7*x6 + k10*x7
C
*     FUNCTION x6_t
      x6_t = k8*x5 - k7*x6
C
*     FUNCTION x7_t
      x7_t = k9*x5 - k10*x7
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      if (t.lt.1) then
        x1_0 = 1
      else
        x1_0 = x1
      endif
C
*     FUNCTION x2_0
      if (t.lt.1) then
        x2_0 = 0
      else
        x2_0 = x2
      endif
C
*     FUNCTION x3_0
      if (t.lt.1) then
        x3_0 = 0
      else
        x3_0 = x3
      endif
C
*     FUNCTION x4_0
      if (t.lt.1) then
        x4_0 = 0
      else
        x4_0 = x4
      endif
C
*     FUNCTION x5_0
      if (t.lt.1) then
        x5_0 = 0
      else
        x5_0 = x5
      endif
C
*     FUNCTION x6_0
      if (t.lt.1) then
        x6_0 = 0
      else
        x6_0 = x6
      endif
C
*     FUNCTION x7_0
      if (t.lt.1) then
        x7_0 = 0
      else
        x7_0 = x7
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
*     FUNCTION x4_fit
      x4_fit = x4
C
*     FUNCTION x5_fit
      x5_fit = x5
C
*     FUNCTION x6_fit
      x6_fit = x6
C
*     FUNCTION x7_fit
      x7_fit = x7
C
*     FUNCTION u_ctrl
      u_ctrl = u(t)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


