C
C------------------------------------------------------
C
C     Problem:    CASTOR
C
C     Date:       23.01.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      M=227          
      T0=631
      H = 1050        
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      CA0, CP, X, TR, Q, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION XP
      M1=M*CA0
      IF (TR.NE.0) THEN
        K=(1/60)*EXP(35.2-22450/TR)
      ELSE
        K=0
      ENDIF
      XP=K*(1-X)
C
*     FUNCTION TRP
      TRP=(-M1*H*K*(1-X)+Q)/(M*CP)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X0
      X0= 0
C
*     FUNCTION TR0
      TR0= T0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION XFIT
      XFIT= X
C
*     FUNCTION TRFIT
      TRFIT= TR
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
