C  
C------------------------------------------------------
C
C     Problem:    CASC_IMP
C  
C     Date:       03.11.1997
C  
C------------------------------------------------------
C
*     PARAMETER
      n = 10
C  
C------------------------------------------------------
C  
*     SET OF INDICES
      ind_n = 1..n  
C  
C------------------------------------------------------
C  
*     TABLE M_w(i), i in ind_n
      1  7.11
      2  3.19
      3  8.16
      4  5.05
      5  8.15
      6  4.6
      7  21.83
      8  15.94
      9  4.93
      10 4.35
C
*     TABLE D0(i), i in ind_n
      1  15.5
      2  9.5
      3  7.4
      4  5.25
      5  3.9
      6  2.5
      7  1.6
      8  0.9
      9  0.55
      10 0.2
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.14
      rho = 1.0E-6
      rh0 = 0.53
      Ta = 20
      Tast = 273.15 + Ta
      a_H2O = 3.638E-4
      b_H2O = 4943
      Cw_a = a_H2O*exp(-b_H2O/Tast)
      Dif = (0.219 + 0.0013*Ta)*1.0E5
      c = 0.008
      n0(i) = 6*M_w(i)/(c*rho*pi*D0(i)**3), i in ind_n
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      FAK, Vluft
      D(i), i in ind_n
      rh, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION D_p(i), i in ind_n
      Tp = Ta - (6.67 + 0.306*Ta)*(1 - rh)
      Cw_p = a_H2O*exp(-b_H2O/(273.15 + Tp))
      if (D(i).gt.FAK*D0(i)) then
        D_p(i) = 4*Dif/(rho*D(i))*(Cw_a*rh - Cw_p)
      else
        D_p(i) = 0
      endif
C
*     FUNCTION rh_p      
      fmax = Cw_a*Vluft*1.0E15
      rh_p =-rho*pi/fmax*sum(n0(i)*D(i)**2*D_p(i), i in ind_n)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION D_0(i), i in ind_n
      D_0(i) = D0(i)
C
*     FUNCTION rh_0
      rh_0 = rh0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION rh_fit
      rh_fit = rh 
C
*     FUNCTION fit_1
      fit_1 = D(1)
C
*     FUNCTION fit_2
      fit_2 = D(2)
C
*     FUNCTION fit_3
      fit_3 = D(3)
C
*     FUNCTION fit_4
      fit_4 = D(4)
C
*     FUNCTION fit_5
      fit_5 = D(5)
C
*     FUNCTION fit_6
      fit_6 = D(6)
C
*     FUNCTION fit_7
      fit_7 = D(7)
C
*     FUNCTION fit_8
      fit_8 = D(8)
C
*     FUNCTION fit_9
      fit_9 = D(9)
C
*     FUNCTION fit_10
      fit_10 = D(10)
C
*     FUNCTION m
      m = rho*pi/6*sum(n0(i)*D(i)**3, i in ind_n)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

