C
C------------------------------------------------------
C
C     Problem:    CSTR
C
C     Date:       24.01.2001
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      Fb1=0.05
      Fb2=0.05
      Fb3=0.05
      V1=1   
      V2=1  
      V3=1   
      A0=1   
      B10=1  
      B20=1   
      B30=1   
      Ain=0    
      Bin=0   
      Pin=0   
      Qin=0   
      k1=1      
      k2=0.1  
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      nA, nP, nB1, nB2, F
      A1, B1, P1, Q1, A2, B2, P2, Q2, A3, B3, P3, Q3, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION A1P
      F1=F+Fb1
      F2=F1+Fb2
      F3=F2+Fb3
      IF ((A1.GT.0).AND.(B1.GT.0)) THEN
        r11=k1*(A1**nA)*(B1**nB1)   
      ELSE
        r11=0
      ENDIF
      IF ((P1.GT.0).AND.(B1.GT.0)) THEN
        r21=k2*(P1**nP)*(B1**nB2)
      ELSE
        r21=0
      ENDIF
      A1P=(F*A0-F1*A1)/V1-r11                 
C
*     FUNCTION B1P
      B1P=(Fb1*B10-F1*B1)/V1-(r11+r21)           
C
*     FUNCTION P1P
      P1P=r11-r21-F1*P1/V1                   
C
*     FUNCTION Q1P
      Q1P=r21-F1*Q1/V1                         
C
*     FUNCTION A2P
      IF ((A2.GT.0).AND.(B2.GT.0)) THEN
        r12=k1*(A2**nA)*(B2**nB1)   
      ELSE
        r12=0
      ENDIF
      IF ((P2.GT.0).AND.(B2.GT.0)) THEN
        r22=k2*(P2**nP)*(B2**nB2)
      ELSE
        r22=0
      ENDIF
      A2P=(F1*A1-F2*A2)/V2-r12                   
C
*     FUNCTION B2P
      B2P=(F1*B1+Fb2*B20-F2*B2)/V2-(r12+r22)        
C
*     FUNCTION P2P
      P2P=r12-r22+(F1*P1-F2*P2)/V2                  
C
*     FUNCTION Q2P
      Q2P=r22+(F1*Q1-F2*Q2)/V2                      
C
*     FUNCTION A3P
      IF ((A3.GT.0).AND.(B3.GT.0)) THEN
        r13=k1*(A3**nA)*(B3**nB1)   
      ELSE
        r13=0
      ENDIF
      IF ((P3.GT.0).AND.(B3.GT.0)) THEN
        r23=k2*(P3**nP)*(B3**nB2)   
      ELSE
        r23=0
      ENDIF
      IF (A3.LT.0) THEN
        A33 = 0
      ELSE
        A33 = A3
      ENDIF
      A3P=(F2*A2-F3*A33)/V3-r13                      
C
*     FUNCTION B3P
      IF (B3.LT.0) THEN
        B33 = 0
      ELSE
        B33 = B3
      ENDIF
      B3P=(F2*B2+Fb3*B30-F3*B33)/V3-(r13+r23)                
C
*     FUNCTION P3P
      P3P=r13-r23+(F2*P2-F3*P3)/V3                  
C
*     FUNCTION Q3P
      Q3P=r23+(F2*Q2-F3*Q3)/V3                      
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION A1_0
      A1_0 = Ain
C
*     FUNCTION B1_0
      B1_0 = Bin
C
*     FUNCTION P1_0
      P1_0 = Pin
C
*     FUNCTION Q1_0
      Q1_0 = Qin
C
*     FUNCTION A2_0
      A2_0 = Ain
C
*     FUNCTION B2_0
      B2_0 = Bin
C
*     FUNCTION P2_0
      P2_0 = Pin
C
*     FUNCTION Q2_0
      Q2_0 = Qin
C
*     FUNCTION A3_0
      A3_0 = Ain
C
*     FUNCTION B3_0
      B3_0 = Bin
C
*     FUNCTION P3_0
      P3_0 = Pin
C
*     FUNCTION Q3_0
      Q3_0 = Qin
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION SEL
      IF ((Q3.GT.0).AND.(P3.GT.0)) THEN
        SEL=P3/(Q3+P3)
      ELSE
        SEL=0
      ENDIF
C
*     FUNCTION PRODUCT
      F1=F+Fb1
      F2=F1+Fb2
      F3=F2+Fb3
      PRODUCT=P3*F3/(V1+V2+V3)
C 
*     FUNCTION A1FIT
      A1FIT = A1
C
*     FUNCTION B1FIT
      B1FIT = B1
C
*     FUNCTION P1FIT
      P1FIT = P1
C
*     FUNCTION Q1FIT
      Q1FIT = Q1
C
*     FUNCTION A2FIT
      A2FIT = A2
C
*     FUNCTION B2FIT
      B2FIT = B2
C
*     FUNCTION P2FIT
      P2FIT = P2
C
*     FUNCTION Q2FIT
      Q2FIT = Q2
C
*     FUNCTION A3FIT
      A3FIT = A3
C
*     FUNCTION B3FIT
      B3FIT = B3
C
*     FUNCTION P3FIT
      P3FIT = P3
C
*     FUNCTION Q3FIT
      Q3FIT = Q3
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
