C
C------------------------------------------------------
C
C     Problem:    CASCADE2
C
C     Date:       11.11.97
C
C------------------------------------------------------
C
*     REAL CONSTANT
      y0 = 0
C
C------------------------------------------------------
C
*     LININT u
      0.0    0.0
      3.0    5.0
      4.0   19.0
      10.0  78.0
      14.0  95.0
      17.0  60.0
      20.0  45.0
      30.0  15.0
      40.0   5.0
      50.0   0.0
C     
*     LININT du_dt
      0.0    0.0
      3.0    1.667
      4.0   14.0
      10.0   9.833
      14.0   4.25
      17.0  -11.6667
      20.0  -5.0
      30.0  -3.0
      40.0  -1.0
      50.0  -0.5
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      alpha1, alpha2, alpha3, y, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y_p
      y_p = (u(t) - y + alpha3*du_dt(t))*(alpha1 + alpha2*y)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y_0
      if (t.lt.1) then
        y_0 = y0
      else
        y_0 = y
      endif    
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y_fit
      y_fit = y
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
