C
C------------------------------------------------------
C
C     Problem:    CASCADE1
C
C     Date:       11.11.97
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..5
C
C------------------------------------------------------
C
*     REAL CONSTANT
      y0 = 0
C
C------------------------------------------------------
C
*     CONINT u
      0.0    0.0
      3.0    5.0
      4.0   19.0
      10.0  78.0
      14.0  95.0
      17.0  60.0
      20.0  45.0
      30.0  15.0
      40.0   5.0
      50.0   0.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      alpha1(i), i in ind
      alpha2(i), i in ind
      beta(i), i in ind
      y(i), i in ind
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y_p(i), i in ind
      if (i.gt.1) then
        ui = beta(i)*u(t) + y(i-1)
      else
        ui = u(t)
      endif
      y_p(i) = (ui - y(i))*(alpha1(i) + alpha2(i)*y(i))
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y_0(i), i in ind
      if (t.lt.1) then
        y_0(i) = Y0
      else
        y_0(i) = y(i)
      endif    
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y_fit
      y_fit = y(5)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION G
      G = sum(beta(i), i in ind) - 1
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
