C
C------------------------------------------------------
C
C     Problem:    CAR_CTR2
C
C     Date:       13.11.2002
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..10
C
C------------------------------------------------------
C
*     INDEX
      i
C
C------------------------------------------------------
C
*     REAL CONSTANT
      alpha = 0.0025
      pi = 3.1415    
C
C------------------------------------------------------
C
*     TABLE tct(j), j in ind
      1   0.10
      2   0.20
      3   0.30
      4   0.40
      5   0.50
      6   0.60
      7   0.70
      8   0.80
      9   0.90
      10  1.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      u(j), j in ind
      tf, tau
      x1, x2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      i = 1
 1000 continue
      if (t.le.tct(i)) then     
        uc = u(i)
        goto 1100
      endif
      i = i+1
      goto 1000
 1100 continue
      if (t.lt.(tf-tau)/tf) then
        x1_t = tf*(4/pi*atan(uc) - alpha*x1**2)
      else
        if (x1.gt.0) then
          x1_t = tf*(4/pi*atan(-0.2) - alpha*x1**2)
        else
          x1_t = 0
        endif
      endif
C
*     FUNCTION x2_t
      x2_t = tf*x1
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      if (t.lt.0.01) then
        x1_0 = 0
      else
        x1_0 = x1
      endif
C
*     FUNCTION x2_0
      if (t.lt.0.01) then
        x2_0 = 0
      else
        x2_0 = x2
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION tf_min
      tf_min = tf
C
*     FUNCTION x1_sim
      x1_sim = x1
C
*     FUNCTION x2_sim
      x2_sim = x2
C
*     FUNCTION u_ctrl
      i = 1
 2000 continue
      if (t.le.tct(i)) then     
        u_ctrl = u(i)
        goto 2100
      endif
      i = i+1
      goto 2000
 2100 continue
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g1
      g1 = x1
C
*     FUNCTION g2
      g2 = x2 - 300
C
*     FUNCTION g3
      g3 = tf - tau
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
