C
C------------------------------------------------------
C
C     Problem:    CARRIER
C
C     Date:       25.07.97
C
C------------------------------------------------------
C
*     REAL CONSTANT
      F = 63.3
      kp = 0.001
      km = 0.007
      V = 3000
      y0 = 60
      u_20 = 0.1
      q0 = 0
      x1 = 0.01
      eps = 0.00001
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      D1, D2, D3
      u1, u2, u3
      u1_x, u2_x, u3_x
      u1_xx, u2_xx, u3_xx
      y, q
      x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION FLUX
C      FLUX = U
C
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u1_t
      if (x.lt.eps) then
        u1_t = -kp*u3
      else
      if (x.gt.x1-eps) then
        u1_t = km*u3
      else
        u1_t = D1*u1_xx
      endif
      endif
C
*     FUNCTION u2_t
      if (x.lt.eps) then
        u2_t = -kp*u3
      else
      if (x.gt.x1-eps) then
        u2_t = km*u3
      else
        u2_t = D2*u2_xx
      endif
      endif
C
*     FUNCTION u3_t
      if (x.lt.eps) then
        u3_t = kp*u1*u2
      else
      if (x.gt.x1-eps) then
        u3_t = -km*u3
      else
        u3_t = D3*u3_xx
      endif
      endif
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u1_0
      u1_0 = 0
C
*     FUNCTION u2_0
      u2_0 = u_20
C
*     FUNCTION u3_0
      u3_0 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
*     FUNCTION y1_t
      y1_t = D1*F*u1_x
C
*     FUNCTION q_t
      q_t = -D1*F*u1_x
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
*     FUNCTION y_0
      y_0 = y0
C
*     FUNCTION q_0
      q_0 = q0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION u1_left
      u1_left = y/V
C
*     FUNCTION u1_right
      u1_right = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
*     FUNCTION u2_x_left
      u2_x_left = 0
C
*     FUNCTION u3_x_left
      u3_x_left = 0
C
*     FUNCTION u2_x_right
      u2_x_right = 0
C
*     FUNCTION u3_x_right
      u3_x_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FIT
      FIT = q
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
