C
C------------------------------------------------------
C
C     Problem:    CARGO
C
C     Date:       23.04.97
C
C------------------------------------------------------
C
*     MACRO u1
      u1 = u11 + u12*t + u13*t**2 + u14*t**3 
C
*     MACRO u2
      u2 = u21 + u22*t + u23*t**2 + u24*t**3  
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      x40, x50, x60
      u11, u12, u13, u14
      u21, u22, u23, u24
      x1, x2, x3, x4, x5, x6, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      x1_t = x4
C
*     FUNCTION x2_t
      x2_t = x5
C
*     FUNCTION x3_t
      x3_t = x6
C
*     FUNCTION x4_t
      x4_t = u1 + x3
C
*     FUNCTION x5_t
      x5_t = u2
C
*     FUNCTION x6_t
      x6_t = (u1 + 27.0756*x3 + 2*x5*x6)/x2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      x1_0 = 0
C
*     FUNCTION x2_0
      x2_0 = 22
C
*     FUNCTION x3_0
      x3_0 = 0
C
*     FUNCTION x4_0
      x4_0 = x40
C
*     FUNCTION x5_0
      x5_0 = x50
C
*     FUNCTION x6_0
      x6_0 = x60
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
*     FUNCTION u1_fit
      u1_fit = u1
C
*     FUNCTION u2_fit
      u2_fit = u2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g1
      g1 = x1 - 4.22
C
*     FUNCTION g2 
      g2 = x2 - 14.4
C
*     FUNCTION g3 
      g3 = x3 + 0.314
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C




