C  
C------------------------------------------------------
C  
C     Problem:    CAMY
C
C     Date:       23.05.2002
C   
C------------------------------------------------------
C  
*     REAL CONSTANT
      R  =  8.16
      T  = -20
      h1 =  215
      h2 =  58
C  
C------------------------------------------------------
C  
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C  
*     VARIABLE
      k10, k20, Eact1, Eact2, s, lag_time, Dia, Nas, time
C  
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C  
*     FUNCTION dDia_dt
      if (time.lt.lag_time) then
        dDia_dt = 0
      else
        k1 = k10*exp(-Eact1/R*T)
        k2 = k20*exp(-Eact2/R*T)
        dDia_dt = -k1*Dia                
      endif 
C  
*     FUNCTION dNas_dt
      if (time.lt.lag_time) then
        dNas_dt = 0
      else
        dNas_dt = k1*Dia - k2*Nas
      endif
C  
C------------------------------------------------------
C  
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Dia_0
      Dia_0 = 0.627746 
C  
*     FUNCTION Nas_0
      Nas_0 = 0
C  
C------------------------------------------------------
C  
C   - Fitting criteria:
C  
*     FUNCTION Qr_net
      k1 = k10*exp(-Eact1/R*T)
      k2 = k20*exp(-Eact2/R*T)
      r1 = k1*Dia
      r2 = k2*Nas
      Qr_net = (r1*h1 + r2*h2)*s
C  
*     FUNCTION Dia_fit
      Dia_fit = Dia
C  
*     FUNCTION Nas_fit
      Nas_fit = Nas
C  
C------------------------------------------------------
C  
C   - Constraints (if exist):
C  
C  *     FUNCTION g1
C        g1 = ...
C  
C------------------------------------------------------
C  
*     END
C  
C------------------------------------------------------
C  








