C
C------------------------------------------------------
C
C     Problem:    CALIBR
C
C     Date:       05.02.1998
C
C------------------------------------------------------
C
*     REAL CONSTANT
      C01   = 0.02759
      C02   = 0.07685
      C03   = 0.19400
      C04   = 0.51102
      VD   = 252  
      VA   = 251000
      F    = 254
      L    = 0.042
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first space derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second space derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. space variable (x)
C     7. time variable (t)
C
*     VARIABLE
      D11, D12, D13, D14, k1, k2, k3, k4
      D21, D22, D23, D24
      u1, u2, u3, u4, u1_x, u2_x, u3_x, u4_x
      u1_xx, u2_xx, u3_xx, u4_xx
      q1, q2, q3, q4, x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u11_p
      u11_p = D11*u1_xx
C
*     FUNCTION u12_p
      u12_p = D12*u2_xx
C
*     FUNCTION u13_p
      u13_p = D13*u3_xx
C
*     FUNCTION u14_p
      u14_p = D14*u4_xx
C
*     FUNCTION u21_p
      u21_p = D21/L**2*u1_xx
C
*     FUNCTION u22_p
      u22_p = D22/L**2*u2_xx
C
*     FUNCTION u23_p
      u23_p = D23/L**2*u3_xx
C
*     FUNCTION u24_p
      u24_p = D24/L**2*u4_xx
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u11_0
      u11_0 = C01
C
*     FUNCTION u12_0
      u12_0 = C02
C
*     FUNCTION u13_0
      u13_0 = C03
C
*     FUNCTION u14_0
      u14_0 = C04
C
*     FUNCTION u21_0
      u21_0 = 0
C
*     FUNCTION u22_0
      u22_0 = 0
C
*     FUNCTION u23_0
      u23_0 = 0
C
*     FUNCTION u24_0
      u24_0 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
*     FUNCTION q1_p
      q1_p = -D21*F/L*u1_x
C
*     FUNCTION q2_p
      q2_p = -D22*F/L*u2_x
C
*     FUNCTION q3_p
      q3_p = -D23*F/L*u3_x
C
*     FUNCTION q4_p
      q4_p = -D24*F/L*u4_x
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
*     FUNCTION q1_0
      q1_0 = 0
C
*     FUNCTION q2_0
      q2_0 = 0
C
*     FUNCTION q3_0
      q3_0 = 0
C
*     FUNCTION q4_0
      q4_0 = 0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION u21_left
      u21_left = k1*u1
C
*     FUNCTION u22_left
      u22_left = k2*u2
C
*     FUNCTION u23_left
      u23_left = k3*u3
C
*     FUNCTION u24_left
      u24_left = k4*u4
C
*     FUNCTION u21_right
      u21_right = k1*q1/VA
C
*     FUNCTION u22_right
      u22_right = k2*q2/VA
C
*     FUNCTION u23_right
      u23_right = k3*q3/VA
C
*     FUNCTION u24_right
      u24_right = k4*q4/VA
C
C------------------------------------------------------
C
C   - Boundary and transition gradients first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION u11_x_left
      u11_x_left = 0
C
*     FUNCTION u12_x_left
      u12_x_left = 0
C
*     FUNCTION u13_x_left
      u13_x_left = 0
C
*     FUNCTION u14_x_left
      u14_x_left = 0
C
*     FUNCTION u11_x_right
      u11_x_right = D21/D11*u1_x/L 
C
*     FUNCTION u12_x_right
      u12_x_right = D22/D12*u2_x/L 
C
*     FUNCTION u13_x_right
      u13_x_right = D23/D13*u3_x/L 
C
*     FUNCTION u14_x_right
      u14_x_right = D24/D14*u4_x/L 
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit1
      fit1 = q1
C
*     FUNCTION fit2
      fit2 = q2
C
*     FUNCTION fit3
      fit3 = q3
C
*     FUNCTION fit4
      fit4 = q4
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
