C
C------------------------------------------------------
C
C     Problem:    CABBAGE
C
C     Date:       28.3.2000
C
C------------------------------------------------------
C
*     REAL CONSTANT
      alpha = 1322
C
C------------------------------------------------------
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      lambda, rL, mueL, rho, rS, rH, mueH, tH, yL, yS, yH, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION yL_t
      yL_t = rL*(alpha + 1)/(alpha + exp(rho*t))*yL - mueL*yL 
C
*     FUNCTION yS_t
      if (yL.gt.0) then
        yS_t = rS*yL*(lambda - yS/yL)
      else
        yS_t = 0
      endif
C
*     FUNCTION yH_t
      if (t.le.tH) then
        f = 0
      else
        f = 1
      endif
      yH_t = (rH*yL - mueH*yH)*f
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION yL_0
      if (t.lt.0.0001) then
        yL_0 = 0.1
      else
        yL_0 = yL
      endif
C
*     FUNCTION yS_0
      if (t.lt.0.0001) then 
        yS_0 = 0.1
      else
        yS_0 = yS
      endif
C
*     FUNCTION yH_0
      if (t.lt.0.0001) then
        yH_0 = 0
      else
        yH_0 = yH
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION yL_fit
      yL_fit = yL
C
*     FUNCTION yS_fit
      yS_fit = yS
C
*     FUNCTION yH_fit
      yH_fit = yH
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
