C
C------------------------------------------------------
C
C     Problem:    B_LYMPHO
C
C     Date:       13.9.2007
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      s, gamma_e, Ke, delta_ea, mu_e, delta_lt, mu_i, delta_i
      E_ea, E_lt, I, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION E_ea_t                                     
      E = E_ea + E_lt
      E_ea_t = s*1.0E6 + gamma_e*(1 - E/(Ke*1.0E7))*E_ea - delta_ea*E_ea
C
*     FUNCTION E_lt_t                                     
      E_lt_t = delta_ea*E_ea - (mu_e + delta_lt)*E_lt
C
*     FUNCTION I_t
      I_t = delta_lt*E_lt - (mu_i + delta_i)*I  
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION E_ea_0
      E_ea_0 = 100000.0
C
*     FUNCTION E_lt_0
      E_lt_0 = 2000000.0
C
*     FUNCTION I_0
      I_0 = 100000
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION E_fit
      E_fit = (E_ea + E_lt)/1E6
C
*     FUNCTION I_fit
      I_fit = I/1E7
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
