C
C------------------------------------------------------
C
C     Problem:    B_BLOCK
C
C     Date:       9.4.1997
C
C------------------------------------------------------
C
*     PARAMETER
      n = 10
C
C------------------------------------------------------
C
*     INDEX
      i
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind_ctrl = 1..n
C
C------------------------------------------------------
C
*     REAL CONSTANT
      a = 18
      k12 = 2.9545
      k21 = 5.7214
      ke = 0.3658
      h = 0.1
      tbreak(j) = h*(j-1), j IN ind_ctrl
C
C------------------------------------------------------
C
*     MACRO u_val
      u_val = 0
      i=2 
 1000 CONTINUE     
      IF ((t.GE.tbreak(i-1)).AND.(t.LT.tbreak(i))) THEN
        u_val = u(i-1)
        goto 1100
      ENDIF
      i=i+1
      IF (i.LE.n) THEN
        GOTO 1000
      ELSE
        i=n
        u_val = u(i)
      ENDIF
 1100 CONTINUE
C
C------------------------------------------------------
C
*     VARIABLE
      u(j), j IN ind_ctrl
      x1, x2, t
C
C------------------------------------------------------
C
*     FUNCTION x1_p
      x1_p = -(k12 + ke)*x1 + k21*x2 + u_val
C
*     FUNCTION x2_p
      x2_p = k12*x1 - k21*x2 
C
C------------------------------------------------------
C
*     FUNCTION x1_0
      IF (t.lt.0.1) THEN
        x1_0 = a
      ELSE
        x1_0 = x1
      ENDIF
C
*     FUNCTION x2_0
      IF (t.lt.0.1) THEN
        x2_0 = 0
      ELSE
        x2_0 = x2
      ENDIF
C
C------------------------------------------------------
C
*     FUNCTION fit1
      fit1 = x1
C
*     FUNCTION fit2
      fit2 = x2
C
*     FUNCTION u_ctrl
      u_ctrl = u_val
C
*     FUNCTION u_exact
      u_exact = a*ke + a*k12*exp(-k21*t)
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


