C
C------------------------------------------------------
C
C     Problem:    BVP_NL
C
C     Date:       10.06.2002
C
C------------------------------------------------------
C
*     REAL CONSTANT
      a = 100
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      x50, x1, x2, x3, x4, x5, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      if (x2.gt.0) then
        x1_t = a*x1/x2*(x3 - x1)
      else
        x1_t = 0
      endif
C
*     FUNCTION x2_t
      x2_t = -a*(x3 - x1)
C
*     FUNCTION x3_t
      if (x2.gt.0) then
        x3_t = (0.9 - 1000*(x3 - x5) - a*x3*(x3 - x1))/x4
      else
        x3_t = 0
      endif
C
*     FUNCTION x4_t
      x4_t = a*(x3 - x1)
C
*     FUNCTION x5_t
      x5_t = -100*(x5 - x3)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      if (t.lt.0.00001) then
        x1_0 = 1
      else
        x1_0 = x1
      endif
C
*     FUNCTION x2_0
      if (t.lt.0.00001) then
        x2_0 = 1
      else
        x2_0 = x2
      endif
C
*     FUNCTION x3_0
      if (t.lt.0.00001) then
        x3_0 = 1
      else
        x3_0 = x3
      endif
C
*     FUNCTION x4_0
      if (t.lt.0.00001) then
        x4_0 = -10
      else
        x4_0 = x4
      endif
C
*     FUNCTION x5_0
      if (t.lt.0.00001) then
        x5_0 = x50
      else
        x5_0 = x5
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
*     FUNCTION x4_fit
      x4_fit = x4
C
*     FUNCTION x5_fit
      x5_fit = x5
C
*     FUNCTION equ
      equ = x3 - x1
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
c*     FUNCTION g
c      g = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



