C
C------------------------------------------------------
C
C     Problem:    BVP4
C
C     Date:       21.5.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      GrS = 1
      Pr = 10
      T0s = -1
      S0s = -1
      k = 2.682
      Sc = 1000
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      Gr, sigma
      W3r0, W3i0, theta1r0, theta1i0, phi1r0, phi1i0
      W0r, W1r, W2r, W3r, W0i, W1i, W2i, W3i
      theta0r, theta1r, theta0i, theta1i
      phi0r, phi1r, phi0i, phi1i
      z
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION W0r_z
      W0r_z = W1r
C
*     FUNCTION W1r_z
      W1r_z = W2r
C
*     FUNCTION W2r_z
      W2r_z = W3r
C
*     FUNCTION W3r_z
      W3r_z = -k**4*W0r - k**2*(GrS*phi0r - Gr*theta0r)
     /      - sigma*(W2i - k**2*W0i) + 2*k**2*W2r
C
*     FUNCTION W0i_z
      W0i_z = W1i
C
*     FUNCTION W1i_z
      W1i_z = W2i
C
*     FUNCTION W2i_z
      W2i_z = W3i
C
*     FUNCTION W3i_z
      W3i_z = -k**4*W0i - k**2*(GrS*phi0i - Gr*theta0i)
     /      + sigma*(W2r - k**2*W0r) + 2*k**2*W2i
C
*     FUNCTION theta0r_z
      theta0r_z = theta1r
C
*     FUNCTION theta1r_z
      theta1r_z = Pr*(T0s*W0r - sigma*theta0i) + k**2*theta0r
C
*     FUNCTION theta0i_z
      theta0i_z = theta1i
C
*     FUNCTION theta1i_z
      theta1i_z = Pr*(T0s*W0i + sigma*theta0r) + k**2*theta0i
C
*     FUNCTION phi0r_z
      phi0r_z = phi1r
C
*     FUNCTION phi1r_z
      phi1r_z = Sc*(S0s*W0r - sigma*phi0i) + k**2*phi0r
C
*     FUNCTION phi0i_z
      phi0i_z = phi1i
C
*     FUNCTION phi1i_z
      phi1i_z = Sc*(S0s*W0i + sigma*phi0r) + k**2*phi0i
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION W0r_0
      W0r_0 = 0
C
*     FUNCTION W1r_0
      W1r_0 = 0
C
*     FUNCTION W2r_0
      W2r_0 = 1
C
*     FUNCTION W3r_0
      W3r_0 = W3r0
C
*     FUNCTION W0i_0
      W0i_0 = 0
C
*     FUNCTION W1i_0
      W1i_0 = 0
C
*     FUNCTION W2i_0
      W2i_0 = 1
C
*     FUNCTION W3i_0
      W3i_0 = W3i0
C
*     FUNCTION theta0r_0
      theta0r_0 = 0
C
*     FUNCTION theta1r_0
      theta1r_0 = theta1r0
C
*     FUNCTION theta0i_0
      theta0i_0 = 0
C
*     FUNCTION theta1i_0
      theta1i_0 = theta1i0
C
*     FUNCTION phi0r_0
      phi0r_0 = 0
C
*     FUNCTION phi1r_0
      phi1r_0 = phi1r0
C
*     FUNCTION phi0i_0
      phi0i_0 = 0
C
*     FUNCTION phi1i_0
      phi1i_0 = phi1i0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION W0r_fit
      W0r_fit = W0r
C
c*     FUNCTION W1r_fit
c      W1r_fit = W1r
C
c*     FUNCTION W2r_fit
c      W2r_fit = W2r
C
*     FUNCTION W0i_fit
      W0i_fit = W0i
C
c*     FUNCTION W1i_fit
c      W1i_fit = W1i
C
c*     FUNCTION W2i_fit
c      W2i_fit = W2i
cC
*     FUNCTION theta0r_fit
      theta0r_fit = theta0r
C
*     FUNCTION theta0i_fit
      theta0i_fit = theta0i
C
*     FUNCTION phi0r_fit
      phi0r_fit = phi0r
C
*     FUNCTION phi0i_fit
      phi0i_fit = phi0i
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g1
      g1 = W0r
C
*     FUNCTION g2
      g2 = W2r
C
*     FUNCTION g3
      g3 = W0i
C
*     FUNCTION g4
      g4 = W2i
C
*     FUNCTION g5
      g5 = theta0r
C
*     FUNCTION g6
      g6 = theta0i
C
*     FUNCTION g7
      g7 = phi0r
C
*     FUNCTION g8
      g8 = phi0i
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
