C
C------------------------------------------------------
C
C     Problem:    BURGER_X
C
C     Date:       11.1.2002
C
C------------------------------------------------------
C
*     SET OF INDICES
      IND=1..5
C
C------------------------------------------------------
C
*     REAL CONSTANT
      EPS = 0.0005
C
C------------------------------------------------------
C
*     MACRO u_ex
      r1 = exp((-x + a - b*t)/(20*eps))
      r2 = exp((-x + a - c*t)/(4*eps))
      r3 = exp((-x + c/2)/(2*eps))
      u_ex = (0.1*r1 + 0.5*r2 + r3)/(r1 + r2 + r3) 
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      a, b, c, u, u_x, u_xx, f, f_x, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION flux
      flux = eps*u_x - 0.5*u**2
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION u_t
      u_t = f_x
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_0
      u_0 = u_ex
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION u_l
      u_l = u_ex
C
*     FUNCTION u_r
      u_r = u_ex
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION u_fit(i), i IN IND
      u_fit(i) = u
c      u_fit(i) = u_ex
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C




