C
C------------------------------------------------------
C
C     Problem:    BURGER_I
C
C     Date:       22.10.1996
C
C------------------------------------------------------
C
*     SET OF INDICES
      IND=1..4
C
C------------------------------------------------------
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      b1, b2, b3, u, u_x, u_xx, f, f_x, x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION flux
      flux = -0.5*u**2
C
*     FUNCTION u_t
      u_t = f_x
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
C------------------------------------------------------
C
*     FUNCTION u_0
      if ((x.le.2).and.(x.ge.0.2)) then
        u_0 = b1
      else
        if ((x.le.3).and.(x.gt.2)) then
          u_0 = b2
        else
          if ((x.le.4.8).and.(x.gt.3)) then
            u_0 = b3
          else
            u_0 = 0
          endif
        endif
      endif
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION u_l
      u_l = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION u_fit(i), i IN IND
      u_fit(i) = u
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C






