C
C------------------------------------------------------
C
C     Problem:    BURGER_F
C
C     Date:       01.11.2001
C
C------------------------------------------------------
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      mue, u, u_x, u_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_t
      u_t = mue*u_xx - u*u_x
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_0
      u_0 = 1.0/(1.0 + exp(x/(2*mue)))
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION u_l
      u_l =1.0/(1.0 + exp(-t/(4*mue)))
C
*     FUNCTION u_r
      u_r = 1.0/(1.0 + exp(1/(2*mue) - t/(4*mue)))
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION u_fit
      u_fit = u
c      u_fit = 1.0/(1.0 + exp(x/(2*mue) - t/(4*mue)))
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


