C
C------------------------------------------------------
C
C     Problem:    BUBB_BIO
C
C     Date:       22.12.97
C
C------------------------------------------------------
C
*     REAL CONSTANT
      dR = 0.15
      HR = 3
      p = 1.5E5
      VLp = 1.5
      epsG = 0.25
      kLaE = 1500
      kLaA = 500
      H = 8.522E4
      muem = 0.6
      YXO = 0.4
      KO = 2.0E-4
      mueD = 0.05
      RQ = 1
      XEOG = 0.21
      R = 8.3
      T = 300
      vG = 1
      epsF = 0.75
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      DF, OF, XOG, X, OF_z, XOG_z, X_z, 
     /   OF_zz, XOG_zz, X_zz, z, time
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION OF_t
      kLa = kLaE - (kLaE - kLaA)*z/HR
      rOX = muem*OF/(YXO*(KO + OF))*X
      OF_t = DF*OF_zz + kLa*(p/H*XOG - OF) - rOX
C
*     FUNCTION XOG_t
      XOG_t = -vG*XOG_z - epsF/epsG*kLa*R*T/p*(p/H*XOG - OF)
C
*     FUNCTION X_t
      X_t = DF*X_zz + rOX*YXO - mueD*X
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION OF_0
      OF_0 = p*XEOG/H
C
*     FUNCTION XOG_0
      XOG_0 = 0.21
C
*     FUNCTION X_0
      X_0 = 0.1
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
C*     FUNCTION v_t
C      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
C*     FUNCTION v_0
C      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION OF_left
      OF_left = 0
C
*     FUNCTION XOG_left
      XOG_left = XEOG
C
*     FUNCTION X_left
      X_left = 0
C
*     FUNCTION OF_right
      OF_right = 0
C
*     FUNCTION X_right
      X_right = 0 
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an areas, etc.:
C
C*     FUNCTION u_x_left
C      u_x_left = ...
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION XOG_fit
      XOG_fit = OF
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
