C
C------------------------------------------------------
C
C     Problem:    BUBBLEC
C
C     Date:       13.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      MB0=2500       
      XB0=0.8        
      R=1e10      
      Pbar=1     
      DM=-4617.8
      CM=13.676
      DW=-5042.6
      CW=13.519
      A=0.85
      B=0.48
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      M0, M, V
      X0, X1, X2, X3, X4, XB, MB, DIST 
      T1, T2, T3, T4, TB
      T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION X0P
      D=V/(R+1)   
      L=V-D
      XW1=1-X1
      GAMM1=EXP(A*XW1*XW1/((XW1+A*X1/B)**2))
      Y1=X1*EXP(CM+DM/(T1+273))*GAMM1/Pbar
      X0P=(V*Y1-(L+D)*X0)/M0  
C
*     FUNCTION X1P
      XW2=1-X2
      GAMM2=EXP(A*XW2*XW2/((XW2+A*X2/B)**2))
      Y2=X2*EXP((CM+DM/(T2+273)))*GAMM2/Pbar
      X1P=(L*(X0-X1)+V*(Y2-Y1))/M
C
*     FUNCTION X2P
      XW3=1-X3
      GAMM3=EXP(A*XW3*XW3/((XW3+A*X3/B)**2))
      Y3=X3*EXP((CM+DM/(T3+273)))*GAMM3/Pbar
      X2P=(L*(X1-X2)+V*(Y3-Y2))/M
C
*     FUNCTION X3P
      XW4=1-X4
      GAMM4=EXP(A*XW4*XW4/((XW4+A*X4/B)**2))
      Y4=X4*EXP((CM+DM/(T4+273)))*GAMM4/Pbar
      X3P=(L*(X2-X3)+V*(Y4-Y3))/M
C
*     FUNCTION X4P
      XWB=1-XB
      GAMMB=EXP(A*XWB*XWB/((XWB+A*XB/B)**2))
      YB=XB*EXP((CM+DM/(TB+273)))*GAMMB/Pbar
      X4P=(L*(X3-X4)+V*(YB-Y4))/M
C
*     FUNCTION XBP
      XBP=(L*X4-V*YB)/MB
C
*     FUNCTION MBP
      MBP=L-V
C
*     FUNCTION DISTP
      DISTP=D 
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION alg_equ1
      XW1=1-X1
      GAMM1=EXP(A*XW1*XW1/((XW1+A*X1/B)**2))
      GAMMW1=EXP(B*X1*X1/((X1+B*XW1/A)**2))
      PP1=EXP((CM+DM/(T1+273)))
      PPW1=EXP((CW+DW/(T1+273)))
      alg_equ1=Pbar-XW1*PPW1*GAMMW1-X1*PP1*GAMM1
C
*     FUNCTION alg_equ2
      XW2=1-X2
      GAMM2=EXP(A*XW2*XW2/((XW2+A*X2/B)**2))
      GAMMW2=EXP(B*X2*X2/((X2+B*XW2/A)**2))
      PP2=EXP((CM+DM/(T2+273)))
      PPW2=EXP((CW+DW/(T2+273)))
      alg_equ2=Pbar-XW2*PPW2*GAMMW2-X2*PP2*GAMM2
C
*     FUNCTION alg_equ3
      XW3=1-X3
      GAMM3=EXP(A*XW3*XW3/((XW3+A*X3/B)**2))
      GAMMW3=EXP(B*X3*X3/((X3+B*XW3/A)**2))
      PP3=EXP((CM+DM/(T3+273)))
      PPW3=EXP((CW+DW/(T3+273)))
      alg_equ3=Pbar-XW3*PPW3*GAMMW3-X3*PP3*GAMM3
C
*     FUNCTION alg_equ4
      XW4=1-X4
      GAMM4=EXP(A*XW4*XW4/((XW4+A*X4/B)**2))
      GAMMW4=EXP(B*X4*X4/((X4+B*XW4/A)**2))
      PP4=EXP((CM+DM/(T4+273)))
      PPW4=EXP((CW+DW/(T4+273)))
      alg_equ4=Pbar-XW4*PPW4*GAMMW4-X4*PP4*GAMM4
C
*     FUNCTION alg_equB
      XWB=1-XB
      GAMMB=EXP(A*XWB*XWB/((XWB+A*XB/B)**2))
      GAMMWB=EXP(B*XB*XB/((XB+B*XWB/A)**2))
      PPB=EXP((CM+DM/(TB+273)))
      PPWB=EXP((CW+DW/(TB+273)))
      alg_equB=Pbar-XWB*PPWB*GAMMWB-XB*PPB*GAMMB
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X0_0
      X0_0 = 0
C
*     FUNCTION X1_0
      X1_0 = 0
C
*     FUNCTION X2_0
      X2_0 = 0
C
*     FUNCTION X3_0
      X3_0 = 0
C
*     FUNCTION X4_0
      X4_0 = 0
C
*     FUNCTION XB_0
      XB_0 = XB0
C
*     FUNCTION MB_0
      MB_0 = MB0
C
*     FUNCTION DIST_0
      DIST_0 = 0
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION T1_0
      T1_0 = 100
C
*     FUNCTION T2_0
      T2_0 = 100
C
*     FUNCTION T3_0
      T3_0 = 100
C
*     FUNCTION T4_0
      T4_0 = 100
C
*     FUNCTION TB_0
      TB_0 = 100
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION X0_fit
      X0_fit = X0
C
*     FUNCTION X1_fit
      X1_fit = X1
C
*     FUNCTION X2_fit
      X2_fit = X2
C
*     FUNCTION X3_fit
      X3_fit = X3
C
*     FUNCTION X4_fit
      X4_fit = X4
C
*     FUNCTION XB_fit
      XB_fit = XB
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
