C
C------------------------------------------------------
C
C     Problem: BUBBLE
C
C     Datum: 11.06.1996
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Durchmess    = 1.0
      Flussighohe  = 4.3
      epsG         = 0.00071036
      epsL         = 1-epsG
      L            = Flussighohe/(1-epsG)
      dVdt_Gas     = 2.025/3600
      Temp         = 273.15 + 17.05
      Vu           = dVdt_Gas/(3.141593/4**Durchmess)
      rohL = 998
      g    = 9.81
      R    = 8.3143
      YLuft= 0.209
      MO2  = 0.032
      MH2O = 0.018
      Paus = 101300
      Henry= 2281433
      satX = 5.2305E-6
      Pu   = Paus + rohL*g*Flussighohe
      DG   = 0.03
      h1   = MH2O/MO2/rohL
      h2   = rohL*g*epsL
      h3   = (Pu*Vu/epsG+2*DG*rohL*g*(1-epsG))
      h4   = MO2/MH2O*rohL*satX/100
      h5   = R/MO2*Temp/epsG
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      kLa, DL, X, Y, dX_z, dY_z, d2X_zz, d2Y_zz, z, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION dX_t
      dX_t = DL*d2X_zz + kLa/epsL*
     *        (100/satX*(Paus+rohL*g*epsL*(L-z))/
     *        Henry/rohL*MH2O/MO2*Y - X)
C
*     FUNCTION dY_t
      dY_t = DG*d2Y_zz - (Pu*Vu/epsG+2*DG*rohL*g*epsL)/
     *        (Paus+rohL*g*epsL*(L-z))*dY_z - kLa/epsG*
     *        R/MO2*Temp* (Y/Henry - MO2/MH2O*rohL/
     *        (Paus+rohL*g*epsL*(L-z))*satX/100*X)
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION X0
      X0 = 0.0
C
*     FUNCTION Y0
      Y0 = 0.0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
c*     FUNCTION v_t
c      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
c*     FUNCTION u_left
c      u_left = 0
C
c*     FUNCTION u_right
c      u_right = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an areas, etc.:
C
C
*     FUNCTION LX_z
      LX_z = 0
C
*     FUNCTION LY_z
      LY_z = ((Vu+rohL/Pu*g*(1-epsG)*DG*epsG)*Y-Vu*YLuft)
     /                                            /(DG*epsG)
C
*     FUNCTION RX_z
      RX_z = 0
C
*     FUNCTION RY_z
      RY_z = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION FIT1
      FIT1 = X
C
*     FUNCTION FIT2
      FIT2 = X
C
*     FUNCTION FIT3
      FIT3 = X
C
*     FUNCTION FIT4
      FIT4 = X
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
