C
C------------------------------------------------------
C
C     Problem:    BSTILL_I
C
C     Date:       12.02.01
C
C------------------------------------------------------
C 
*     PARAMETER
      NRES = 50
      N = 5
      N1 = 6
      NR = 10
      NR1 = 9
C
C------------------------------------------------------
C 
*     INDEX
      J
C------------------------------------------------------
C 
*     SET OF INDICES
      INDRES = 1..NRES
      INDN = 1..N 
      INDN1 = 1..N1
      INDR = 1..NR
      INDR1 = 1..NR1
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      A = 3.5    
      M0 = 100        
      MB0 = 2500         
      M = 20          
      XNR0 = 0.8      
      V = 10         
C
C------------------------------------------------------
C 
*     TABLE TB(I), I IN INDN1
      1   75.0
      2  190.0
      3  250.0
      4  370.0
      5  520.0
      6 5000.0 
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      R(I), I IN INDN
      X0
      X(I), I IN INDR1
      XNR
      DIST, MB, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION X0P
      IF (T.GE.TB(1)) THEN
      J = 1
 1000 CONTINUE
      IF ((T.GE.TB(J)).AND.(T.LT.TB(J+1))) THEN
        RT = R(J)
        GOTO 2000
      ENDIF
      J = J+1 
      IF (J.LT.N1) THEN
        GOTO 1000
      ENDIF
      J = N
      RT = R(J)
 2000 CONTINUE
      ELSE
      RT = 1E10
      ENDIF
      D = V/(RT+1)   
      L = V-D   
      Y1 = A*X(1)/(1+(A-1)*X(1))
      X0P = (V*Y1-(L+D)*X0)/M0
C
*     FUNCTION XP(I), I IN INDR1
      Y1 = A*X(I)/(1+(A-1)*X(I))
      IF (I.LT.NR1) THEN
        Y2 = A*X(I+1)/(1+(A-1)*X(I+1))
      ELSE
        Y2 = A*XNR/(1+(A-1)*XNR)
      ENDIF
      IF (I.GT.1) THEN
        XP(I) = (L*(X(I-1)-X(I))+V*(Y2-Y1))/M 
      ELSE 
        XP(I) = (L*(X0-X(I))+V*(Y2-Y1))/M 
      ENDIF
C
*     FUNCTION XNRP
      YNR = A*XNR/(1+(A-1)*XNR)
      J = NR1
      XNRP = (L*X(J)-V*YNR)/MB  
C
*     FUNCTION DISTP
      DISTP = D 
C
*     FUNCTION MBP
      MBP = L-V 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X0_0
      IF(T.LT.0.1) THEN
        X0_0 = 0
      ELSE
        X0_0 = X0
      ENDIF
C
*     FUNCTION X_0(I), I IN INDR1
      IF (T.LT.0.1) THEN
        X_0(I) = 0
      ELSE
        X_0(I) = X(I)
      ENDIF
C
*     FUNCTION XNR_0
      IF (T.LT.0.1) THEN
        XNR_0 = XNR0
      ELSE
        XNR_0 = XNR
      ENDIF
C
*     FUNCTION DIST_0
      IF (T.LT.0.1) THEN
        DIST_0 = 0
      ELSE
        DIST_0 = DIST
      ENDIF
C
*     FUNCTION MB_0
      IF (T.LT.0.1) THEN
        MB_0 = MB0
      ELSE
        MB_0 = MB
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION X0_fit
      X0_fit = X0
C
*     FUNCTION X_fit(I), I IN INDR1
      X_fit(I) = X(I)
C
*     FUNCTION XNR_fit
      XNR_fit = XNR
C
*     FUNCTION DIST_fit
      DIST_fit = DIST
C
*     FUNCTION MB_fit
      MB_fit = MB
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
