C
C------------------------------------------------------
C
C     Problem:    BSTILL
C
C     Date:       12.02.01
C
C------------------------------------------------------
C 
*     SET OF INDICES
      IND=1..50
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      A   = 3.5    
      M0  = 100        
      MB0 = 2500         
      M   = 20          
      X80 = 0.8      
      V   = 10         
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      R1, R2, R3, R4
      X0, X1, X2, X3, X4, X5, X6, X7, X8, DIST, MB, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION X0P
      R = 1E10
      IF (T.GT.75) THEN
        R = R1
        IF (T.GT.190) THEN
          R = R2
          IF (T.GT.250) THEN
            R = R3
            IF (T.GT.370) THEN
              R = R4
            ENDIF
          ENDIF
        ENDIF
      ENDIF
      D   = V/(R + 1)   
      L   = V - D   
      Y1  = A*X1/(1 + (A - 1)*X1)
      Y2  = A*X2/(1 + (A - 1)*X2)
      Y3  = A*X3/(1 + (A - 1)*X3)
      Y4  = A*X4/(1 + (A - 1)*X4)
      Y5  = A*X5/(1 + (A - 1)*X5)
      Y6  = A*X6/(1 + (A - 1)*X6)
      Y7  = A*X7/(1 + (A - 1)*X7)
      Y8  = A*X8/(1 + (A - 1)*X8)
      X0P = (V*Y1 - (L + D)*X0)/M0  
C
*     FUNCTION X1P
      X1P = (L*(X0 - X1) + V*(Y2 - Y1))/M 
C
*     FUNCTION X2P
      X2P = (L*(X1 - X2) + V*(Y3 - Y2))/M 
C
*     FUNCTION X3P
      X3P = (L*(X2 - X3) + V*(Y4 - Y3))/M 
C
*     FUNCTION X4P
      X4P = (L*(X3 - X4) + V*(Y5 - Y4))/M 
C
*     FUNCTION X5P
      X5P = (L*(X4 - X5) + V*(Y6 - Y5))/M 
C
*     FUNCTION X6P
      X6P = (L*(X5 - X6) + V*(Y7 - Y6))/M 
C
*     FUNCTION X7P
      X7P = (L*(X6 - X7) + V*(Y8 - Y7))/M 
C
*     FUNCTION X8P
      X8P = (L*X7 - V*Y8)/MB  
C
*     FUNCTION DISTP
      DISTP = D 
C
*     FUNCTION MBP
      MBP = L - V 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X0_0
      IF(T.LT.0.1) THEN
        X0_0 = 0
      ELSE
        X0_0 = X0
      ENDIF
C
*     FUNCTION X1_0
      IF(T.LT.0.1) THEN
        X1_0 = 0
      ELSE
        X1_0 = X1
      ENDIF
C
*     FUNCTION X2_0
      IF(T.LT.0.1) THEN
        X2_0 = 0
      ELSE
        X2_0 = X2
      ENDIF
C
*     FUNCTION X3_0
      IF(T.LT.0.1) THEN
        X3_0 = 0
      ELSE
        X3_0 = X3
      ENDIF
C
*     FUNCTION X4_0
      IF(T.LT.0.1) THEN
        X4_0 = 0
      ELSE
        X4_0 = X4
      ENDIF
C
*     FUNCTION X5_0
      IF(T.LT.0.1) THEN
        X5_0 = 0
      ELSE
        X5_0 = X5
      ENDIF
C
*     FUNCTION X6_0
      IF(T.LT.0.1) THEN
        X6_0 = 0
      ELSE
        X6_0 = X6
      ENDIF
C
*     FUNCTION X7_0
      IF(T.LT.0.1) THEN
        X7_0 = 0
      ELSE
        X7_0 = X7
      ENDIF
C
*     FUNCTION X8_0
      IF(T.LT.0.1) THEN
        X8_0 = X80
      ELSE
        X8_0 = X8
      ENDIF
C
*     FUNCTION DIST_0
      IF(T.LT.0.1) THEN
        DIST_0 = 0
      ELSE
        DIST_0 = DIST
      ENDIF
C
*     FUNCTION MB_0
      IF(T.LT.0.1) THEN
        MB_0 = MB0
      ELSE
        MB_0 = MB
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION X0_fit
      X0_fit=X0
C
*     FUNCTION X1_fit
      X1_fit = X1
C
*     FUNCTION X2_fit
      X2_fit = X2
C
*     FUNCTION X3_fit
      X3_fit = X3
C
*     FUNCTION X4_fit
      X4_fit = X4
C
*     FUNCTION X5_fit
      X5_fit = X5
C
*     FUNCTION X6_fit
      X6_fit = X6
C
*     FUNCTION X7_fit
      X7_fit = X7
C
*     FUNCTION X8_fit
      X8_fit = X8
C
*     FUNCTION DIST_fit
      DIST_fit = DIST
C
*     FUNCTION MB_fit
      MB_fit = MB
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION G(I), I IN IND
      G(I) = X0 - 0.9
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C










