C
C------------------------------------------------------
C
C     Problem:    BRUSSEL1
C
C     Date:       23.05.2001
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, k3, k4, A, B, D, E, X, Y, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION A_t
      A_t = -k1*A
C
*     FUNCTION B_t
      B_t = -k2*B*X
C
*     FUNCTION D_t
      D_t = k2*B*X
C
*     FUNCTION E_t
      E_t = k4*X
C
*     FUNCTION X_t
      X_t = k1*A - k2*B*X + k3*X**2*Y - k4*X
C
*     FUNCTION Y_t
      Y_t = k2*B*X - k3*X**2*Y
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION A_0
      A_0 = 1.5
C
*     FUNCTION B_0
      B_0 = 2
C
*     FUNCTION D_0
      D_0 = 0
C
*     FUNCTION E_0
      E_0 = 0
C
*     FUNCTION X_0
      X_0 = 0
C
*     FUNCTION Y_0
      Y_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION X_fit
      X_fit = X

*     FUNCTION Y_fit
      Y_fit = Y
C
*     FUNCTION A_fit
      A_fit = A
C
*     FUNCTION B_fit
      B_fit = B
C
*     FUNCTION D_fit
      D_fit = D
C
*     FUNCTION E_fit
      E_fit = E
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
