C
C------------------------------------------------------
C
C     Problem:    BRUSSEL
C
C     Date:       16.09.1996
C
C------------------------------------------------------
C
*     REAL CONSTANT
      EPS = 0.002
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      a, b, c, u, v, u_x, v_x, u_xx, v_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_t
      u_t = eps*u_xx + u**2*v - a*u + 1
C
*     FUNCTION v_t
      v_t = eps*v_xx - u**2*v + b*u
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_0
      u_0 = 0.5
C
*     FUNCTION v_0
      v_0 = 1 + 5*x - 0.25*tanh(c*x) - 0.25*tanh(c*(x-1))
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
c*     FUNCTION VP
c      VP = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
c*     FUNCTION V0
c      V0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
*     FUNCTION ul_x
      ul_x = 0.0
C
*     FUNCTION vl_x
      vl_x = 0.0
C
*     FUNCTION ur_x
      ur_x = 0.0
C
*     FUNCTION vr_x
      vr_x = 0.0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION u_fit1
      u_fit1 = u
C
*     FUNCTION v_fit1
      v_fit1 = v
C
*     FUNCTION u_fit2
      u_fit2 = u
C
*     FUNCTION v_fit2
      v_fit2 = v
C
*     FUNCTION u_fit3
      u_fit3 = u
C
*     FUNCTION v_fit3
      v_fit3 = v
C
*     FUNCTION u_fit4
      u_fit4 = u
C
*     FUNCTION v_fit4
      v_fit4 = v
C
*     FUNCTION u_fit5
      u_fit5 = u
C
*     FUNCTION v_fit5
      v_fit5 = v
C
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


