C
C------------------------------------------------------
C
C     Problem:    BRUSS2D
C
C     Date:       12.10.2006
C
C------------------------------------------------------
C                   
*     PARAMETER
      N = 20
      N0 = 19
      N1 = 21
C
C------------------------------------------------------
C                   
*     SET OF INDICES
      ind = 1..N
      ind1 = 1..N1
      ind0 = 1..N0
C
C------------------------------------------------------
C                   
*     REAL CONSTANT
      h = 1/N 
C       
*     INDEX    
      j, j0, j1, j2        
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations(u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (One
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.)
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      a, b, alpha
      u(i), i in ind1
      v(i), i in ind1
      u_x(i), i in ind1
      v_x(i), i in ind1
      u_xx(i), i in ind1
      v_xx(i), i in ind1
      x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: all 
C     functions in first area, then all functions in
C     second area, etc.):
C
*     FUNCTION u0_t
      u0_t = 1 + u(1)**2*v(1) - a*u(1) + alpha*(u_xx(1) + u_x(2)/h) 
C
*     FUNCTION u_t(i), i in ind0   
      j = i + 1
      u_t(i) = 1 + u(j)**2*v(j) - a*u(j) + alpha*(u_xx(j) + (u_x(j+1)-u_x(j-1))/(2*h))
C
*     FUNCTION uN_t                                           
      j = N1                                                  
      uN_t = 1 + u(j)**2*v(j) - a*u(j) + alpha*(u_xx(j)-u_x(j-1)/h) 
C
*     FUNCTION v0_t
      v0_t = b*u(1) - u(1)**2*v(1) + alpha*(v_xx(1) + v_x(2)/h) 
C
*     FUNCTION v_t(i), i in ind0 
      j = i + 1
      v_t(i) = b*u(j) - u(j)**2*v(j) + alpha*(v_xx(j) + (v_x(j+1)-v_x(j-1))/(2*h))
C
*     FUNCTION vN_t
      j = N1                                                  
      vN_t = b*u(j) - u(j)**2*v(j) + alpha*(v_xx(j)-v_x(j-1)/h) 
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: all initial values in 
C     first area, then all initial values in second 
C     area, etc.):
C      
*     FUNCTION u_0(i), i in ind1
      j = i
      u_0(i) = 0.5 + (j-1)*h
C      
*     FUNCTION v_0(i), i in ind1
      v_0(i) = 1 + 5*x
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
C*     FUNCTION v_t
C      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
C*     FUNCTION v_0
C      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
C*     FUNCTION u_left
C      u_left = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION u_x_left(i), i in ind1
      u_x_left(i) = 0
C
*     FUNCTION v_x_left(i), i in ind1
      v_x_left(i) = 0
C
*     FUNCTION u_x_right(i), i in ind1
      u_x_right(i) = 0
C
*     FUNCTION v_x_right(i), i in ind1
      v_x_right(i) = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
c*     FUNCTION fit0
c      fit0 = u(1)
C
*     FUNCTION fit(i), i in ind
      fit(i) = u(i)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
