C
C------------------------------------------------------
C
C     Problem:    BRUNHILD
C
C     Date:       31.01.1997
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      theta1, theta2, theta3, theta4, theta5, theta6
      f1, f2, f3, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION f1_p
      f1_p = -(theta1 + theta2)*f1 + theta3*f2
C
*     FUNCTION f2_p
      f2_p = theta2*f1 - (theta3 + theta4)*f2 + theta5*f3
C
*     FUNCTION f3_p
      f3_p = theta4*f2 - theta5*f3
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION f1_0
      f1_0 = theta6*1.0E+5
C
*     FUNCTION f2_0
      f2_0 = 0
C
*     FUNCTION f3_0
      f3_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit
      fit = f1
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
