C
C------------------------------------------------------
C
C     Problem:    BRINE
C
C     Date:       19.06.97
C
C------------------------------------------------------
C
*     REAL CONSTANT
      k = 1
      mu = 1
      p0 = 1
      omega0 = 1
      rho0 = 1
      g = 0.0981
      n = 0.2
      gamma = 0.1794
      beta = 1.0E-5
      L = 1
      pleft = 1.7
      pright = 1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      lambda
      omega, p, omega_x, p_x, omega_xx, p_xx
      fomega, fp, fomega_x, fp_x
      x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION flux1
      rho = rho0*exp(beta*(p-p0) + gamma*omega)
      q = -k/mu*(p_x + rho*g)
      J = -lambda*abs(q)*omega_x
      flux1 = rho*J
C
*     FUNCTION flux2
      flux2 = rho*q
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION omega_t
      rho = rho0*exp(beta*(p-p0) + gamma*omega)  
      q = -k/mu*(p_x + rho*g)
      omega_t = -omega_x*q/n - fomega_x/(n*rho)
C
*     FUNCTION p_t
      p_t = -omega_t*gamma/beta - fp_x/(n*rho*beta)
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION omega_0
      omega_0 = 0
C
*     FUNCTION p_0
      p_0 = p0*((1 - x/L)*pleft + x/L*pright)
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION omega_l
      if (t.lt.0.75) then
        omega_l = omega0
      else
        omega_l = 0
      endif
C
*     FUNCTION p_l
      p_l = p0*pleft
C
*     FUNCTION p_r
      p_r = p0*pright
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
*     FUNCTION omega_rx
      omega_rx = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit
      fit = omega
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

