C
C------------------------------------------------------
C
C     Problem:    BOND
C
C     Date:       24.11.2001
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      ks1, k2, k3, ks4, x1, x2, y, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      k1 = ks1*1.0e-10
      k4 = ks4*1.0e-10
      x1_t = -k1*x1 + k2*y
C
*     FUNCTION x2_t
      x2_t = -k4*x1 + k3*y
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION equ
      equ = k1*x1 + k4*x2 - (k2 + k3)*y
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      x1_0 = 0
C
*     FUNCTION x2_0
      x2_0 = 1
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION y_0
      y_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION y_fit
      y_fit = y
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


