C
C------------------------------------------------------
C
C     Problem:    BLYMPH
C
C     Date:       30.7.2007
C
C------------------------------------------------------
C                         
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      s, gamma_e, K_e, delta_e, mue_e, delta_l, mue_i, delta_i
      E_e, E_l, I, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION E_e_t                  
      E = E_e + E_l
      E_e_t = s*1.0E6 + gamma_e*(1 - E/(K_e*1.0E7))*E_e 
     /        - delta_e*E_e
C
*     FUNCTION E_l_t
      E_l_t = delta_e*E_e - (mue_e + delta_l)*E_l 
C
*     FUNCTION I_t
      I_t = delta_l*E_l - (mue_i + delta_i)*I 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION E_e_0 
      E_e_0 = 0
C
*     FUNCTION E_l_0 
      E_l_0 = 0
C
*     FUNCTION I_0 
      I_0 = 0
C
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION E_fit  
      E = E_e + E_l
      cells = 1E7
      E_fit = E/(3.2*cells)
C
*     FUNCTION I_fit
      I_fit = I/(10*cells)
C
*     FUNCTION E_e_fit
      E_e_fit = E_e
C
*     FUNCTION E_l_fit
      E_l_fit = E_l
C      
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
