C
C------------------------------------------------------
C
C     Problem:     BLOOD_S
C
C     Date:        15.09.97
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. system variables (z)
C     3. time variable (t)
C
*     VARIABLE
      p1, p2, p3, x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     nonlinear equations:
C
*     FUNCTION f
      if (t.le.2) then
        f = p1*(exp(x) - 1) - p2*x - (p1 - p2)**2*t/p3
      else
        f = p3*x + 0.8*(exp(x) - 1) - (2 - t)*p2
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of nonlinear
C     equations:
C
*     FUNCTION x_0
      x_0 = 0 
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION y
      if (t.le.2) then
        y = p1*p3*(exp(x) - 1)/(p1 - p2)
      else
        y = 0.8*exp(x)
      endif
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
