C
C------------------------------------------------------
C
C     Problem:    BLOOD
C
C     Date:       13.12.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      PLini = 10.0
      fourth = 0.1
      kcatX = 1.00E+04
      kPL = 1.00E+03
      kcatII = 2.00E+03
      Vini = 1.30E+03
      IIini = 1.433E+03
      RVV4 = 0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      kmX, kiXa, kPT, kcatV, kmV, kmII
      kcat2, kiIIaAT, kiIIaA2, Xini
      X, Xa, V, Va, PL, PT, II, IIa, IIaA2M, RVVini, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION X_t
      RVV = (1 - fourth)*RVVini + fourth*RVV4
      X_t = -kcatX*X*RVV/(kmX + X)
C
*     FUNCTION Xa_t
      Xa_t = kcatX*X*RVV/(kmX + X) - kiXa*Xa - kPT*Va*Xa*PL +
     /       kPL*PT
C
*     FUNCTION V_t
      V_t = -kcatV*V*IIa/(kmV + V)
C
*     FUNCTION Va_t
      Va_t = kcatV*V*IIa/(kmV + V) - kPT*Va*Xa*PL + kPL*PT
C
*     FUNCTION PL_t
      PL_t = -kPT*Va*Xa*PL + kPL*PT
C
*     FUNCTION PT_t
      PT_t = kPT*Va*Xa*PL - kPL*PT
C
*     FUNCTION II_t
      II_t = -kcatII*II*PT/(kmII + II) - kcat2*Xa
C
*     FUNCTION IIa_t
      IIa_t = kcatII*II*PT/(kmII + II) + kcat2*Xa -
     /             kiIIaAT*IIa - kiIIaA2*IIa
C
*     FUNCTION IIaA2M_t 
      IIaA2M_t = kiIIaAT*IIa
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X_0
      X_0 = Xini
C
*     FUNCTION Xa_0
      Xa_0 =0.0
C
*     FUNCTION V_0
      V_0 = Vini
C
*     FUNCTION Va_0
      Va_0 = 0.0
C
*     FUNCTION PL_0
      PL_0 = PLini
C
*     FUNCTION PT_0
      PT_0 =0.0
C
*     FUNCTION II_0
      II_0 = IIini
C
*     FUNCTION IIa_0
      IIa_0 =0.0
C
*     FUNCTION IIaA2M_0
      IIaA2M_0 = 0.0
C
C------------------------------------------------------
C*
C   - Fitting criteria:
C
*     FUNCTION AmAct
      AmAct =  IIa + 0.556*IIaA2M 
C
*     FUNCTION X_fit
      X_fit = X
C
*     FUNCTION Xa_fit
      Xa_fit = Xa
C
*     FUNCTION V_fit
      V_fit = V
C
*     FUNCTION Va_fit
      Va_fit = Va
C
*     FUNCTION PL_fit
      PL_fit = PL
C
*     FUNCTION PT_fit
      PT_fit = PT
C
*     FUNCTION II_fit
      II_fit = II
C
*     FUNCTION IIa_fit
      IIa_fit = IIa
C
*     FUNCTION IIaA2M_fit
      IIaA2M_fit = IIaA2M
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
