C
C------------------------------------------------------
C
C     Problem:    BLD_BRN
C
C     Date:       7.2.1996
C
C------------------------------------------------------
C
*     REAL CONSTANT
      D0 = 12.0
      Vp = 1.0
      Fa = 1.0
      X1 = 0.1
      X2 = 0.11
      X3 = 0.21
      Ueb1 = -50.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      K12, K23, K24, K42, K56, K65, D1, D3, Vert1, Vert2
      U, Ux, Uxx
      Y1, Y2, Y3, Y4, Ch, Cc
      F, Fx
      X, T
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION Flux1
      Flux1 = 0
C
*     FUNCTION Flux2
      Flux2 = (D1+(D3-D1)/(X2-X1)*(X - X1))*(Ueb1*U + UX)
C
*     FUNCTION Flux3
      Flux3 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION U1p
      U1p = D1*Uxx
C
*     FUNCTION U2p
      U2p = Fx
C
*     FUNCTION U3p
      U3p = D3*Uxx
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION U10
      U10 = 0.0
C 
*     FUNCTION U20
      U20 = 0.0
C 
*     FUNCTION U30
      U30 = 0.0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
*     FUNCTION Y1p
      Y1p = -K12*Y1
C 
*     FUNCTION Y2p
      Y2p = K12*Y1  + K42*Y4 - (K23 + K24)*Y2 + Fa*D1*Ux
C 
*     FUNCTION Y3p
      Y3p = K23*Y2 
C 
*     FUNCTION Y4p
      Y4p = -K42*Y4  + K24*Y2
C
*     FUNCTION Chp
      Chp = -Fa*D3*Ux - K56*Ch + K65*Cc
C
*     FUNCTION Ccp
      Ccp = K56*Ch - K65*Cc
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
*     FUNCTION Y10
      Y10 = D0
C
*     FUNCTION Y20
      Y20 = 0
C
*     FUNCTION Y30
      Y30 = 0
C
*     FUNCTION Y40
      Y40 = 0
C
*     FUNCTION Ch0
      Ch0 = 5
C
*     FUNCTION Cc0
      Cc0 = 0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION Uleft1
      Uleft1 = Vert1*Y2/Vp
C
*     FUNCTION Uleft2
      Uleft2 = U
C
*     FUNCTION Uright2
      Uright2 = U
C
*     FUNCTION Uright3
      Uright3 = Vert2*Ch
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. space 
C     variable first at left borders of all areas, then 
C     at right borders of all areas:
C
*     FUNCTION Uxright1
      Uxright1 = Ueb1*U + Ux 
C
*     FUNCTION Uxleft3
      Uxleft3 = Ueb1*U + Ux
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION Fit1
      Fit1 = Y1
C
*     FUNCTION Fit2
      Fit2 = Ch
C
*     FUNCTION Fit3
      Fit3 = Cc
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
