C
C------------------------------------------------------
C
C     Problem:    BITUMEN
C
C     Date:       31.05.2002
C
C------------------------------------------------------
C
*     REAL CONSTANT
      k10 = 1E+3
      k20 = 1E+7
      k30 = 1E+1
      k40 = 1E-3
      k50 = 1
C
C------------------------------------------------------
C
*     LININT Temp
        0.0   275.0
       80.0   275.0
      110.0   415.0
      420.0   415.0
      450.0   300.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      E1R, E2R, E3R, E4R, E5R, x1, x2, x3, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      k1 = k10*exp(-E1R*1000/Temp(t))
      k2 = k20*exp(-E2R*1000/Temp(t))
      k3 = k30*exp(-E3R*1000/Temp(t))
      k4 = k40*exp(-E4R*1000/Temp(t))
      k5 = k50*exp(-E5R*1000/Temp(t))
      x1_t = -k1*x1 - k2*x1 
C
*     FUNCTION x2_t
      x2_t = k1*x1 - (k3 + k4)*x2
C
*     FUNCTION x3_t
      x3_t = k3*x2 - k5*x3
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      IF (t.lt.0.1) THEN
        x1_0 = 1
      ELSE
        x1_0 = x1
      ENDIF
C
*     FUNCTION x2_0
      IF (t.lt.0.1) THEN
        x2_0 = 0
      ELSE
        x2_0 = x2
      ENDIF
C
*     FUNCTION x3_0
      IF (t.lt.0.1) THEN
        x3_0 = 0
      ELSE
        x3_0 = x3
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

