C
C------------------------------------------------------
C
C     Problem:    BIO_REAC
C
C     Date:       15.10.2002
C
C------------------------------------------------------
C     
*     REAL CONSTANT
      V1 = 0.0357
      V2 = 0.779      
      V3 = 7.16
      V4 = 0.933
      V5 = 0.128
      V6 = 0.0664   
      ni1 = 0.4
      na1 = 6.3
      ni2 = 0.06
      na2 = 2.3
      ni3 = 2
      na3 = 2                     
      kcat1 = 1
      kcat2 = 1
      kcat3 = 3   
      eps = 1E-5
C
C------------------------------------------------------
C     
*     PARAMETER
      n = 3
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..n
C
C------------------------------------------------------
C
*     INDEX 
      i
C
C------------------------------------------------------
C
*     TABLE Sv(j), j in ind
      1  0.1
      2  0.1
      3  0.1 
C
*     TABLE Pv(j), j in ind
      1  0.05
      2  0.13572
      3  0.3684
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      Ki1_inv, Ka1, k_1, Ki2_inv, Ka2, k_2, Ki3_inv, Ka3 
      k_3, K4, k_4, K5, k_5, K6, k_6, Km1, Km2, Km3, Km4
      Km5, Km6, G1, G2, G3, E1, E2, E3, M1, M2, c, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION G1_t
      i = 1
      ri = 1
 1000 continue   
      if (c.lt.ri) then
        S = Sv(i)
        P = Pv(i)
        goto 2000
      endif
      i = i+1
      ri = ri+1
      if (i.le.n) then
        goto 1000
      endif
 2000 continue     
      G1_t = V1/(1 + abs(P*Ki1_inv+eps)**ni1 + abs(Ka1/S+eps)**na1) - k_1*G1
C
*     FUNCTION G2_t
      G2_t = V2/(1 + abs(P*Ki2_inv+eps)**ni2 + abs(Ka2/M1+eps)**na2) - k_2*G2
C
*     FUNCTION G3_t
      G3_t = V3/(1 + abs(P*Ki3_inv+eps)**ni3 + abs(Ka3/M2+eps)**na3) - k_3*G3
C
*     FUNCTION E1_t
      E1_t = V4*G1/(K4 + G1) - k_4*E1
C
*     FUNCTION E2_t
      E2_t = V5*G2/(K5 + G2) - k_5*E2
C
*     FUNCTION E3_t
      E3_t = V6*G2/(K6 + G3) - k_6*E3
C
*     FUNCTION M1_t             
      W = kcat2*E2/Km3*(M1 - M2)/(1 + M1/Km3 + M2/Km4)
      M1_t = kcat1*E1/Km1*(S - M1)/(1 + S/Km1 + M1/Km2) - W
C              
*     FUNCTION M2_t
      M2_t = W - kcat3*E3/Km5*(M2 - P)/(1 + M2/Km5 + P/Km6)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION G1_0
      G1_0 = 0.66667
C
*     FUNCTION G2_0
      G2_0 = 0.57254
C
*     FUNCTION G3_0
      G3_0 = 0.41758
C
*     FUNCTION E1_0
      E1_0 = 0.4
C
*     FUNCTION E2_0
      E2_0 = 0.36409
C
*     FUNCTION E3_0
      E3_0 = 0.29457
C
*     FUNCTION M1_0
      M1_0 = 1.419
C
*     FUNCTION M2_0
      M2_0 = 0.93464
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION G1_fit
      G1_fit = G1
C
*     FUNCTION G2_fit
      G2_fit = G2
C
*     FUNCTION G3_fit
      G3_fit = G3
C
*     FUNCTION E1_fit
      E1_fit = E1
C
*     FUNCTION E2_fit
      E2_fit = E2
C
*     FUNCTION E3_fit
      E3_fit = E3
C
*     FUNCTION M1_fit
      M1_fit = M1
C
*     FUNCTION M2_fit
      M2_fit = M2
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
