C
C------------------------------------------------------
C
C     Problem:    BIO_MOD
C
C     Date:       31.01.2002
C
C------------------------------------------------------
C
*     REAL CONSTANT
      KI = 0.1
      Kp = 0.001
      K1 = 1
      K2 = 10
      Pf = 1
      S_in = 1
      X0 = 0.001
      P0 = 0.02
      mue_max = 100
      nu_max = 56
C
C------------------------------------------------------
C
*     LININT D
      0.0    2.0
      20.0   2.0
      22.0   0.1
      50.0   0.1
      60.0   2.0
      90.0   2.0
      105.0  0.1
      115.0  0.1
      125.0  2.0
      200.0  2.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      eta1, eta2, X, P, S, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION X_t
      mue = mue_max*S*KP*(1 - P/Pf)/(K1 + S + S**2/KI)/(KP + P)
      X_t = mue*X - D(t)*X
C
*     FUNCTION P_t
      nu = nu_max*S/(K2 + S)
      P_t = nu*X - D(t)*P
C
*     FUNCTION S_t
      S_t = -eta1*mue*X - eta2*nu*X + D(t)*(S_in - S)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X_0
      if (t.lt.0.1) then
        X_0 = X0
      else
        X_0 = X
      endif
C
*     FUNCTION P_0
      if (t.lt.0.1) then
        P_0 = P0
      else
        P_0 = P
      endif
C
*     FUNCTION S_0
      if (t.lt.0.1) then
        S_0 = 0
      else
        S_0 = S
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION X_fit
      X_fit = X
C
*     FUNCTION P_fit
      P_fit = P
C
*     FUNCTION S_fit
      S_fit = S
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

