C
C------------------------------------------------------
C
C     Problem:    BIOREAC
C
C     Date:       18.01.2007
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Tm = 320
C
C------------------------------------------------------
C
*     LININT T
      0.0     290.0
      2000.0  340.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k2m, kdm, Kmm, E2m, Edm, EKm, s, eact, time
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION s_t
      k2 = k2m*exp(-E2m*(1/T(time) - 1/Tm))
      kd = kdm*exp(-Edm*(1/T(time) - 1/Tm))      
      Km = Kmm*1.0E5*exp(-EKm*(1/T(time) - 1/Tm))
      s_t = -k2*eact*s/(Km + s) 

C
*     FUNCTION eact_t
      eact_t = -kd*eact/(1 + 1/Km)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION s_0
      s_0 = 10
C
*     FUNCTION eact_0
      eact_0 = 10000
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION s_fit
      s_fit = s
C
*     FUNCTION eact_fit
      eact_fit = eact
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

