C
C------------------------------------------------------
C
C     Problem:    BIOPROC
C
C     Date:       21.12.1994
C
C------------------------------------------------------
C
*     SET OF INDICES
      INDEX=1..10
C
C------------------------------------------------------
C
*     REAL CONSTANT
      K1=2.0
      K2=0.7
      K3=500.0
C
C------------------------------------------------------
C
*     TABLE C(I), I IN INDEX
      1   1.30E-3
      2   4.59E-4
      3  -4.10E-4
      4   2.27E-4
      5  -5.66E-5
      6   7.47E-6
      7  -5.57E-7
      8   2.36E-8
      9  -5.29E-10
      10  4.88E-12  
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      K4, K5, K6, K7, Y1, Y2, Y3, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Y1P
      IF (T.GT.0) THEN
         U=SUM(C(I)*T**I, I IN INDEX)/T
      ELSE
         U = C(1)
      ENDIF
      Y1P = -K1*Y1/(Y1+K2)*EXP(Y3) + K3*U
C
*     FUNCTION Y2P
      Y2P = K4*(K1*Y1/(Y1+K2) - K5*K6/(Y2+K6))*EXP(Y3) - Y2*U
C
*     FUNCTION Y3P
      Y3P = K7*Y1/(Y1+K2)*K6/(Y2+K6) - U
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Y10
      Y10 = 0.104
C
*     FUNCTION Y20
      Y20 = 0
C
*     FUNCTION Y30
      Y30 = 0.69
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Y1FIT
      Y1FIT = Y1
C
*     FUNCTION Y2FIT
      Y2FIT = Y2
C
*     FUNCTION Y3FIT
      Y3FIT = Y3
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


