C
C------------------------------------------------------
C
C     Problem:    BIOKAT
C
C     Date:       11.02.2004
C
C------------------------------------------------------
C                                       
*     REAL CONSTANT
      Tref = 250
c293
      Mas1 = 0.1362
      Mas2 = 0.09806
      Mas3 = 0.23426
      Mas4 = 0.236
      R = 8.314
      na1 = 41.5
      na2 = 43.37
      na4 = 0.4
      c_kat = 1.71
      temp = 20
C
C------------------------------------------------------
C                                            
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, E1, k_kat, E_kat, lambda, n1, n2, n3, time
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION n1_t                    
      n4 = na4
      m = n1*Mas1 + n2*Mas2 + n3*Mas3 + n4*Mas4 
      T = 273 + temp
      k = k1*exp(-E1*10000/R*(1/T - 1/Tref))
     /    + k_kat*c_kat*exp(-lambda*time)*exp(-E_kat*10000/R*(1/T - 1/Tref))
      n1_t = -k*n1*n2/m
C
*     FUNCTION n2_t
      n2_t = -k*n1*n2/m
C
*     FUNCTION n3_t
      n3_t = k*n1*n2/m
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION n1_0
      n1_0 = na1
C
*     FUNCTION n2_0
      n2_0 = na2
C
*     FUNCTION n3_0
      n3_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit
      n4 = na4
      m = n1*Mas1 + n2*Mas2 + n3*Mas3 + n4*Mas4 
      fit = n3*Mas3/m*100
C
*     FUNCTION n1_plot
      n1_plot = n1
C
*     FUNCTION n2_plot
      n2_plot = n2
C
*     FUNCTION n3_plot
      n3_plot = n3
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
