C
C------------------------------------------------------
C
C     Problem:    BIOFILM
C
C     Date:       14.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      SFEED=50
      V=0.014
      F=0.014
      KLA=100  
      A=2000
      Z=0.00005
      OS=8
      YOS=2  
      KS=3
      KI=100  
      KO=0.5 
      S00=10
      P00=8
      L=0.0005
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations(u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      DS, DP, VM, S, P, S_x, P_x, S_xx, P_xx, S0, P0, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: all 
C     functions in first area, then all functions in
C     second area, etc.):
C
*     FUNCTION S_t
      RS=-VM*1000*S/(KS+S+(S*S)/KI)*(P/(KO+P))
      S_t=DS*1E-6*S_xx + RS
C
*     FUNCTION P_t
      RP=YOS*RS 
      P_t=DP*1E-6*P_xx + RP
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: all initial values in 
C     first area, then all initial values in second 
C     area, etc.):
C
*     FUNCTION S_0
      S_0=S00*(1-x/L*0.995)
C
*     FUNCTION P_0
      P_0=P00*(1-x/L*7.95/8)
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
*     FUNCTION S0P
      S0P=(F/V)*(SFEED-S0)+A*DS*1E-6*S_x    
C
*     FUNCTION P0P
      P0P=KLA*(OS-P0)+A*DP*1E-6*P_x 
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
*     FUNCTION S0_0
      S0_0=S00
C
*     FUNCTION P0_0
      P0_0=P00
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION S_left
      S_left=S0
C
*     FUNCTION P_left
      P_left=P0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION S_x_right
      S_x_right=0
C
*     FUNCTION P_x_right
      P_x_right=0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION S_fit
      S_fit=S0
C
*     FUNCTION P_fit
      P_fit=P0
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
