C
C------------------------------------------------------
C
C     Problem:    BIODEG
C
C     Date:       22.03.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      mu_max = 0.118
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      p1, p2, p3, p4, y10, y20, y30, te, y1, y2, y3, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      if (t.lt.te) then
         y1_t = -p1*y1*y3
      else
         y1_t = 0
      endif
C
*     FUNCTION y2_t
      if (t.lt.te) then
        y2_t = (p1*y1 - mu_max/p2)*y3
      else                  
        if (p3.gt.0) then
          y2_t = -mu_max/p3*y3*y2/(y2 + p4)
        else 
          y2_t = 1
        endif
      endif
C
*     FUNCTION y3_t
      if (t.lt.te) then
        y3_t = mu_max*y3
      else
        y3_t = mu_max*y3*y2/(y2 + p4)
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      if (t.lt.te) then
        y1_0 = y10
      else
        y1_0 = y1
      endif
C
*     FUNCTION y2_0
      if (t.lt.te) then
        y2_0 = y20
      else
        y2_0 = y2
      endif
C
*     FUNCTION y3_0
      if (t.lt.te) then
        y3_0 = y30
      else
        y3_0 = y3
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
*     FUNCTION y3_fit
      y3_fit = y3
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C




