C
C------------------------------------------------------
C
C     Problem:    BINDSITE
C
C     Date:       02.02.00
C
C------------------------------------------------------
C    
*     REAL CONSTANT
      L = 0.1
      Hct = 0.3
      Viv = 0.07
      Vp = Viv*(1 - Hct)
      Vev = 1 - Viv 
      Dp = 0.01
      Dev = 0.2*Dp
      k = 6.3128e-003
      SA01 = 3.1736e-001
      SA02 = 3.0733e-003
C
C------------------------------------------------------
C
*     SPLINE Cp01
      0.0    0.0
      0.0833 0.0
      0.0933 3.70E-02
      0.1033 8.04E-02
      0.1133 2.48E-01
      0.1233 7.38E-01
      0.1333 1.60E+00
      0.1433 3.10E+00
      0.1533 4.27E+00
      0.1633 6.17E+00
      0.1733 7.22E+00
      0.1833 8.02E+00
      0.2833 7.97E+00
      0.3833 4.00E+00
      0.4833 2.55E+00
      0.5833 1.74E+00
      0.7833 1.32E+00
      0.9833 7.75E-01
      1.1833 5.89E-01
      1.3833 4.80E-01
      1.5353 4.47E-01
      1.7833 4.23E-01
      2.0833 3.10E-01
      2.5833 2.83E-01
      4.0833 2.68E-01
      5.0833 2.32E-01
      10.0833 2.14E-01
      15.0833 1.52E-01
      20.2833 1.21E-01
      30.4833 1.02E-01
      40.0833 7.21E-02
      50.0833 6.38E-02
      60.0833 5.15E-02
      70.0833 4.26E-02
      80.0833 3.53E-02
      91.5833 2.78E-02
      100.0833 2.43E-02
      107.2833 2.12E-02
      112.3833 1.88E-02
      200.0833 1.63E-02
C
*     SPLINE Cp02
      0.0  0.0
      100.0  0.0
      110.0  0.0
      114.0   0.0
      114.1800 0.0000
      114.1900 10.6510
      114.2100 18.2540
      114.2200 28.8300
      114.2300 45.3150
      114.2400 80.7520
      114.2500 200.5000
      114.2600 311.5300
      114.2700 370.8500
      114.3700 428.5000
      114.4700 326.2100
      114.5700 191.1000
      114.6700 126.6000
      114.8700 94.4440
      115.0700 63.0900
      115.2700 49.0690
      115.4700 37.3340
      115.5400 33.4160
      115.7700 26.3250
      116.3700 20.1630
      116.7700 16.8920
      118.1700 15.0350
      119.1700 12.9640
      124.1700 11.4370
      129.1700 9.0689
      134.1700 7.7982
      139.6700 6.6808
      142.2700 5.7337
      183.1700 5.3848
      199.1700 1.4683
      200.0   0.0
      220.0   0.0
C
*     SPLINE Ca1
      0.0    0.0
      0.0833 0.0000
      0.0933 0.0180
      0.1033 0.0391
      0.1133 0.1206
      0.1233 0.3594
      0.1333 0.7792
      0.1433 1.5139
      0.1533 2.0858
      0.1633 3.0119
      0.1733 3.5272
      0.1833 3.9236
      0.2833 3.9031
      0.3833 1.9726
      0.4833 1.2637
      0.5833 0.8717
      0.7833 0.6615
      0.9833 0.3947
      1.1833 0.3040
      1.3833 0.2508
      1.5353 0.2369
      1.7833 0.2261
      2.0833 0.1682
      2.5833 0.1560
      4.0833 0.1524
      5.0833 0.1423
      10.0830 0.1374
      15.0830 0.1154
      20.2830 0.1030
      30.4830 0.0938
      40.0830 0.0751
      50.0830 0.0738
      60.0830 0.0662
      70.0830 0.0609
      80.0830 0.0560
      91.5830 0.0491
      100.0800 0.0485
      107.2800 0.0462
      112.3800 0.0443
      200.0800 0.0405
C
*     SPLINE Ca2
      0.0  0.0
      100.0  0.0
      110.0  0.0
      114.0   0.0
      114.1800 0.0000
      114.1900 0.0164
      114.2000 0.0298
      114.2100 0.0284
      114.2200 0.0450
      114.2300 0.0711
      114.2400 0.1272
      114.2500 0.3170
      114.2600 0.4944
      114.2700 0.5909
      114.3700 0.6854
      114.4700 0.5422
      114.5700 0.3296
      114.6700 0.2263
      114.8700 0.1747
      115.0700 0.1246
      115.2700 0.1029
      115.4700 0.0827
      115.5400 0.0778
      115.7700 0.0623
      116.3700 0.0502
      116.7700 0.0469
      118.1700 0.0441
      119.1700 0.0430
      124.1700 0.0399
      129.1700 0.0356
      134.1700 0.0335
      139.6700 0.0314
      142.2700 0.0297
      183.1700 0.0292
      199.1700 0.0166
      200.0    0.0
      220.0    0.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      kon, koff, Bmax, Qp, PScap, SF
      Cp1, Cp2, Cev1, Cev2, CB1, CB2
      Cp1_x, Cp2_x, Cev1_x, Cev2_x, CB1_x, CB2_x
      Cp1_xx, Cp2_xx, Cev1_xx, Cev2_xx, CB1_xx, CB2_xx
      x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION Cp1_t
      Cp1_t = -Qp*L/Vp*Cp1_x + Dp*Cp1_xx - PScap/Vp*(Cp1 - Cev1)
C
*     FUNCTION Cp2_t
      Cp2_t = -Qp*L/Vp*Cp2_x + Dp*Cp2_xx - PScap/Vp*(Cp2 - Cev2)
C
*     FUNCTION Cev1_t
      Cev1_t = Dev*Cev1_xx + PScap/Vev*(Cp1 - Cev1)
     /       - kon*Cev1*(Bmax - (CB1 + CB2)) + koff*CB1
C
*     FUNCTION Cev2_t
      Cev2_t = Dev*Cev2_xx + PScap/Vev*(Cp2 - Cev2)
     /       - kon*Cev2*(Bmax - (CB1 + CB2)) + koff*CB2
C
*     FUNCTION CB1_t
      CB1_t = kon*Cev1*(Bmax - (CB1 + CB2)) - koff*CB1
C
*     FUNCTION CB2_t
      CB2_t = kon*Cev2*(Bmax - (CB1 + CB2)) - koff*CB2
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION Cp1_0
      Cp1_0 = 0
C
*     FUNCTION Cp2_0
      Cp2_0 = 0
C
*     FUNCTION Cev1_0
      Cev1_0 = 0
C
*     FUNCTION Cev2_0
      Cev2_0 = 0
C
*     FUNCTION CB1_0
      CB1_0 = 0
C
*     FUNCTION CB2_0
      CB2_0 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
c*     FUNCTION v_t
c      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION Cp1_left
      Cp1_left = Cp01(t)
C
*     FUNCTION Cp2_left
      Cp2_left = Cp02(t)
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION Cev1_x_left
      Cev1_x_left = 0
C
*     FUNCTION Cev2_x_left
      Cev2_x_left = 0
C
*     FUNCTION Cp1_x_right
      Cp1_x_right = 0
C
*     FUNCTION Cp2_x_right
      Cp2_x_right = 0
C
*     FUNCTION Cev1_x_right
      Cev1_x_right = 0
C
*     FUNCTION Cev2_x_right
      Cev2_x_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION PET
      w1 = SA01*exp(-k*t)*(SIMPSN(3,1) + SIMPSN(5,1))/L
      w2 = SA02*exp(-k*t)*(SIMPSN(4,1) + SIMPSN(6,1))/L
      PET = SF*(Ca1(t) + Ca2(t)) + w1 + w2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

