C
C------------------------------------------------------
C
C     Problem:    BIFURC2
C
C     Date:       20.02.2002
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..20
C
C------------------------------------------------------
C
*     REAL CONSTANT
      alpha = 2.08
C
C------------------------------------------------------
C
*     LININT z10
      0.0    0.005
      5.0    0.012
      10.0   0.018
      15.0   0.011
      20.0   0.005
      30.0  -0.002
      40.0  -0.005
      50.0  -0.002
      60.0   0.0
      70.0   0.001
      80.0  -0.009
      90.0  -0.015
      100.0 -0.01
C
*     LININT z20
      0.0    0.0
      10.0   0.1
      20.0   0.2
      30.0   0.2
      40.0   0.1
      50.0   0.0
      60.0  -0.1
      70.0  -0.5
      80.0  -0.2
      90.0   0.0
      100.0  0.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations(u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      mue, kappa, z1, z2, z1_x, z2_x, z1_xx, z2_xx, v1, v2, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: all 
C     functions in first area, then all functions in
C     second area, etc.):
C
*     FUNCTION z1_t
      z1_t = z2
C
*     FUNCTION z2_t
      z2_t = (mue - z1**2)*z2 - z1 - alpha*z1**2 - z1**3 + z1_xx 
     /       + kappa*z2_xx
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: all initial values in 
C     first area, then all initial values in second 
C     area, etc.):
C
*     FUNCTION z1_0
      z1_0 = z10(x)
C
*     FUNCTION z2_0
      z2_0 = z20(x)
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
*     FUNCTION equ1
      equ1 = z1_x - v1
C
*     FUNCTION equ2
      equ2 = z1 - v2
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
*     FUNCTION v1_0
      v1_0 = 1
C
*     FUNCTION v2_0
      v2_0 = 1
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION z1_left
      z1_left = v2
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION z1_x_right
      z1_x_right = v1
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit(i), i in ind
      fit(i) = z1
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

