C
C------------------------------------------------------
C
C     Problem:    BENZHYD
C
C     Date:       06.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      tr = 1033  
      k1 = 1.496e7*exp(-15200/tr) 
      k2 = 8.670e6*exp(-15200/tr) 
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      keq1, keq2, x1, x2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1p
      PB = 1-x1-x2 
      PD = x1/2-x2 
      PH = x1/2+x2 
      PT = x2  
      r1 = k1*(PB*PB-PD*PH/keq1)  
      r2 = k2*(PB*PD-PH*PT/keq2)  
      x1p = r1
C
*     FUNCTION x2p
      x2p = r2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      x1_0 = 0
C
*     FUNCTION x2_0
      x2_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
