C
C------------------------------------------------------
C
C     Problem:    BENZENE
C
C     Date:       14.10.98
C
C------------------------------------------------------
C
*     REAL CONSTANT
      KK1 = 0.242
      KK2 = 0.428
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, x1, x2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      r1 = k1*(x1**2 - x2*(2 - 2*x1 - x2)/(3*KK1))
      r2 = k2*(x1*x2 - (1 - x1 - 2*x2)*(2 - 2*x1 - x2)/(9*KK2))
      x1_t = -r1 - r2
C
*     FUNCTION x2_t
      x2_t = r1/2 - r2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      x1_0 = 1
C
*     FUNCTION x2_0
      x2_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
