C
C------------------------------------------------------
C
C     Problem:    BELUSOV
C
C     Date:       23.11.97
C
C------------------------------------------------------
C
*     REAL CONSTANT
      k1 = 1.34
      k5 = 1
      s2 = 1E+9
      s3 = 1E+3
      s4 = 1E+7
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k2, k3, k4, y1, y2, y3, y4, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_p
      y1_p = -y1*(k1*y3 + s3*k3*y2)
C
*     FUNCTION y2_p
      y2_p = -y2*(s2*k2*y3 - s3*k3*y1 + s4*k4*y2) + k1*y1*y3
C
*     FUNCTION y3_p
      y3_p = -y3*(k1*y1 + s2*k2*y2) + k5*y4
C
*     FUNCTION y4_p
      y4_p = -k5*y4 + s3*k3*y1*y2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = 0.06
C
*     FUNCTION y2_0
      y2_0 = 5.01E-11
C
*     FUNCTION y3_0
      y3_0 = 3.3E-7
C
*     FUNCTION y4_0
      y4_0 = 2.4E-8
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
*     FUNCTION y3_fit
      y3_fit = y3
C
*     FUNCTION y4_fit
      y4_fit = y4
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C





