C
C------------------------------------------------------
C
C     Problem:    PARAB8
C
C     Date:       05.06.1999
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..4
C
C------------------------------------------------------
C
*     REAL CONSTANT
      u0 = 10 
      nu = -59.2
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      D, mue, u, u_x, u_xx, f, f_x, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION flux1
      flux1 = D*u_x
C 
*     FUNCTION flux 
      v = nu*6.25**5*(x - 0.5)**5
      flux = D*u_x - u*v
C 
*     FUNCTION flux3
      flux3 = D*u_x
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u1_t
      u1_t = f_x - mue*u
C
*     FUNCTION u2_t
      u2_t = f_x - mue*u
C
*     FUNCTION u3_t
      u3_t = f_x - mue*u
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u1_0
      u1_0 = 0
C
*     FUNCTION u2_0
      if (x.ge.0.5) then
        u2_0 = u0
      else
        u2_0 = 0
      endif
C
*     FUNCTION u3_0
      u3_0 = u0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
c*     FUNCTION VP
c      VP = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
c*     FUNCTION V0
c      V0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION u1_left
      u1_left = 0
C 
*     FUNCTION u1_right
      u1_right = u
C 
*     FUNCTION u2_right
      u2_right = u
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C 
*     FUNCTION u2_x_left
      u2_x_left = u
C 
*     FUNCTION u3_x_left
      u3_x_left = u
C 
*     FUNCTION u3_x_right
      u3_x_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit(i), i in ind
      fit(i) = u
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C







